% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ping}
\alias{get_conn_defaults}
\alias{get_conn_error}
\alias{get_conn_info}
\alias{ping}
\alias{reset_conn_defaults}
\alias{set_conn_defaults}
\alias{set_default_password}
\title{Database connection utilities}
\usage{
ping(opts = "")

get_conn_error()

get_conn_defaults(all = FALSE)

get_conn_info(what = NULL)

set_conn_defaults(...)

set_default_password(password = NULL)

reset_conn_defaults()
}
\arguments{
\item{opts}{a libpq connection string}

\item{all}{if false return only defaults with settings}

\item{what}{the fields to return or all if NULL}

\item{...}{a named list of arguments giving new defaults}

\item{password}{the password}
}
\value{
\code{ping} returns one of the following:
\tabular{ll}{
\code{PQPING_OK}  \tab Server reachable \cr
\code{PQPING_REJECT} \tab Server reachable but not accepting
connections \cr
\code{PQPING_NO_RESPONSE} \tab Server unreachable \cr
\code{PQPING_NO_ATTEMPT} \tab Connection string is nonsense \cr}

get_conn_error: an error string

\code{get_conn_defaults}: a data frame with defaults listed

get_conn_info: a list of values
}
\description{
Conection reporting and defaults
}
\details{
\code{ping} will ignore any keywords not directly
related to the database host (e.g., username, dbname) as it
does not connect; it only detect the server port is responding.

\code{get_conn_defaults} returns a data frame containing
all of the possible connection string keywords, the names of environment
variables used to override the defaults, the compiled in default value
and the current value of the keyword.

\code{get_conn_info} returns a list containing
information about the current connection. For
readability, it will print as though it is a matrix. If
you want to see it as a list, try \code{unclass(get_conn_info())}.

If \code{length(what) == 1} then \code{get_conn_info} returns
a scalar

\code{set_conn_defaults} sets the connection defaults by calling
\code{\link{Sys.setenv}} and setting the environment variable associated
with the connection keywords returned by \code{get_conn_defaults(all = TRUE)}.
These settings will only last as long as the current shell session and will
reset after a new login.

\code{set_default_password} will query for a password (if not supplied)
and set the \code{PGPASSWORD} environment variable accordingly. This can be used
with \code{\link{psql}} and \code{\link{copy_to}}.

\code{reset_conn_defaults} unsets all environment variables returned
by \code{get_conn_defaults(all = TRUE)}.
}
\examples{
\dontrun{
ping("connect_timeout = 3, host = www.keittlab.org")
connect()
get_conn_defaults()
set_conn_defaults(dbname = "test")
get_conn_defaults()
reset_conn_defaults()
get_conn_defaults()
get_conn_defaults(all = TRUE)
get_conn_info()
get_conn_error()
disconnect()}
}
\author{
Timothy H. Keitt
}

