% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list_tables}
\alias{describe_table}
\alias{list_tables}
\title{PostgreSQL database information}
\usage{
list_tables(only.names = TRUE)

describe_table(tablename, schemaname = NULL)
}
\arguments{
\item{only.names}{if true, just list the table names}

\item{tablename}{the name of a PostgreSQL table}

\item{schemaname}{if not null, look only in this schema}
}
\value{
\code{list_tables}: a vector of table names or a data frame

\code{describe_table}: a data frame with column information
}
\description{
Get information about tables in a database
}
\examples{
\dontrun{
system("createdb rpgtesting")
connect("rpgtesting")
begin()

# write data frame contents
data(mtcars)
write_table(mtcars)

# get some information
list_tables()
describe_table("mtcars")

#cleanup
rollback()
disconnect()
system("dropdb rpgtesting")}
}
\author{
Timothy H. Keitt
}
\seealso{
\code{\link{psql}}
}

