% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_core_utilities.R
\name{testPackage}
\alias{testPackage}
\title{Test Package}
\usage{
testPackage(
  outDir = ".",
  ...,
  completeUnitTestSetEnabled = TRUE,
  types = "tests",
  sourceDirectory = NULL
)
}
\arguments{
\item{outDir}{The output directory where all test results shall be saved.
By default the current working directory is used.}

\item{completeUnitTestSetEnabled}{If \code{TRUE} (default) all existing unit tests will
be executed; a subset of all unit tests will be used otherwise.}

\item{types}{The type(s) of tests to be done. Can be one or more of
\code{c("tests", "examples", "vignettes")}. Default is "tests" only.}

\item{sourceDirectory}{An optional directory to look for \code{.save} files.}
}
\description{
This function allows the installed package \code{rpact} to be tested.
}
\details{
This function creates the subdirectory \code{rpact-tests} in the specified output directory
and copies all unit test files of the package to this newly created directory.
Then the function runs all tests (or a subset of all tests if 
\code{completeUnitTestSetEnabled} is \code{FALSE}) using 
\code{\link[tools]{testInstalledPackage}}.
The test results will be saved to the text file \code{testthat.Rout} that can be found
in the subdirectory \code{rpact-tests}.
}
\examples{

\dontrun{
testPackage()
}

}
\keyword{internal}
