% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_time.R
\name{getPiecewiseSurvivalTime}
\alias{getPiecewiseSurvivalTime}
\title{Get Piecewise Survival Time}
\usage{
getPiecewiseSurvivalTime(piecewiseSurvivalTime = NA_real_, ...,
  lambda1 = NA_real_, lambda2 = NA_real_, hazardRatio = NA_real_,
  pi1 = NA_real_, pi2 = NA_real_, median1 = NA_real_,
  median2 = NA_real_, eventTime = C_EVENT_TIME_DEFAULT, kappa = 1,
  delayedResponseAllowed = FALSE)
}
\arguments{
\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for the piecewise 
definition of the exponential survival time cumulative distribution function (see details).}

\item{...}{Ensures that all arguments after \code{piecewiseSurvivalTime} are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{lambda1}{The assumed hazard rate in the treatment group, there is no default.
lambda1 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{lambda2}{The assumed hazard rate in the reference group, there is no default.
lambda2 can also be used to define piecewise exponentially distributed survival times 
(see details).}

\item{hazardRatio}{The vector of hazard ratios under consideration. 
If the event or hazard rates in both treatment groups are defined, the hazard ratio needs 
not to be specified as it is calculated.}

\item{pi1}{The assumed event rate in the treatment group, default is \code{seq(0.4, 0.6, 0.1)}.}

\item{pi2}{The assumed event rate in the control group, default is 0.2.}

\item{median1}{The assumed median survival time in the treatment group, there is no default.}

\item{median2}{The assumed median survival time in the reference group, there is no default.}

\item{eventTime}{The assumed time under which the event rates are calculated, default is \code{12}.}

\item{kappa}{The shape parameter of the Weibull distribution, default is \code{1}. 
The Weibull distribution cannot be used for the piecewise definition of 
the survival time distribution. 
Note that the parameters \code{shape} and \code{scale} in \code{\link[stats]{Weibull}} 
are equivalent to \code{kappa} and \code{1 / lambda}, respectively, in rpact.}

\item{delayedResponseAllowed}{If \code{TRUE}, delayed response is allowed;
otherwise it will be validatet that the definition is not delayed, default is \code{FALSE}.}
}
\value{
Returns a \code{\link{PiecewiseSurvivalTime}} object.
}
\description{
Returns a \code{PiecewiseSurvivalTime} object that contains the all relevant parameters 
of an exponential survival time cumulative distribution function.
}
\details{
\code{piecewiseSurvivalTime} 
The first element of this vector must be equal to \code{0}. \code{piecewiseSurvivalTime} can also 
be a list that combines the definition of the time intervals and hazard rates in the reference group. 
The definition of the survival time in the treatment group is obtained by the specification 
of the hazard ratio (see examples for details).
}
\examples{

pwst <- getPiecewiseSurvivalTime(lambda2 = 0.5, hazardRatio = 0.8)
pwst

pwst <- getPiecewiseSurvivalTime(lambda2 = 0.5, lambda1 = 0.4)
pwst

pwst <- getPiecewiseSurvivalTime(pi2 = 0.5, hazardRatio = 0.8)
pwst

pwst <- getPiecewiseSurvivalTime(pi2 = 0.5, pi1 = 0.4)
pwst

pwst <- getPiecewiseSurvivalTime(pi1 = 0.3)
pwst

pwst <- getPiecewiseSurvivalTime(hazardRatio = c(0.6, 0.8), lambda2 = 0.4)
pwst

pwst <- getPiecewiseSurvivalTime(piecewiseSurvivalTime = c(0, 6, 9), 
    lambda2 = c(0.025, 0.04, 0.015), hazardRatio = 0.8)
pwst

pwst <- getPiecewiseSurvivalTime(piecewiseSurvivalTime = c(0, 6, 9), 
    lambda2 = c(0.025, 0.04, 0.015), 
    lambda1 = c(0.025, 0.04, 0.015) * 0.8)
pwst

pwst <- getPiecewiseSurvivalTime(list(
    "0 - <6"   = 0.025, 
    "6 - <9"   = 0.04, 
    "9 - <15"  = 0.015, 
    "15 - <21" = 0.01, 
    ">=21"     = 0.007), hazardRatio = 0.75)
pwst

\donttest{

# The object created by getPiecewiseSurvivalTime() can be used directly in getSampleSizeSurvival():
getSampleSizeSurvival(piecewiseSurvivalTime = pwst)

# The object created by getPiecewiseSurvivalTime() can be used directly in getPowerSurvival():
getPowerSurvival(piecewiseSurvivalTime = pwst, 
    maxNumberOfEvents = 40, maxNumberOfSubjects = 100)

}
 
}
