% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primitives.R
\name{head}
\alias{head}
\alias{head.SO3}
\alias{head.Q4}
\title{Return the First or Last Parts of an Object}
\usage{
\method{head}{SO3}(x, n = 6L, ...)

\method{head}{Q4}(x, n = 6L, ...)
}
\arguments{
\item{x}{an object}

\item{n}{an integer vector of length up to \code{dim(x)} (or 1,
    for non-dimensioned objects). Values specify the indices to be
    selected in the corresponding dimension (or along the length) of the
    object. A positive value of \code{n[i]} includes the first/last
    \code{n[i]} indices in that dimension, while a negative value
    excludes the last/first \code{abs(n[i])}, including all remaining
    indices. \code{NA} or non-specified values (when \code{length(n) <
      length(dim(x))}) select all indices in that dimension. Must
    contain at least one non-missing value.}

\item{...}{arguments to be passed to or from other methods.}
}
\value{
An object (usually) like \code{x} but generally smaller.  Hence, for
  \code{\link{array}}s, the result corresponds to \code{x[.., drop=FALSE]}.
  For \code{\link{ftable}} objects \code{x}, a transformed \code{format(x)}.
}
\description{
Returns the first or last parts of a vector, matrix, table, data frame
  or function.  Since \code{head()} and \code{tail()} are generic
  functions, they may also have been extended to other classes.
}
\details{
For vector/array based objects, \code{head()} (\code{tail()}) returns
  a subset of the same dimensionality as \code{x}, usually of
  the same class. For historical reasons, by default they select the
  first (last) 6 indices in the first dimension ("rows") or along the
  length of a non-dimensioned vector, and the full extent (all indices)
  in any remaining dimensions. \code{head.matrix()} and
  \code{tail.matrix()} are exported.

  The default and array(/matrix) methods for \code{head()} and
  \code{tail()} are quite general. They will work as is for any class
  which has a \code{dim()} method, a \code{length()} method (only
  required if \code{dim()} returns \code{NULL}), and a \code{[} method
  (that accepts the \code{drop} argument and can subset in all
  dimensions in the dimensioned case).

  For functions, the lines of the deparsed function are returned as
  character strings.

  When \code{x} is an array(/matrix) of dimensionality two and more,
  \code{tail()} will add dimnames similar to how they would appear in a
  full printing of \code{x} for all dimensions \code{k} where
  \code{n[k]} is specified and non-missing and \code{dimnames(x)[[k]]}
  (or \code{dimnames(x)} itself) is \code{NULL}.  Specifically, the
  form of the added dimnames will vary for different dimensions as follows:
  \describe{
    \item{\code{k=1} (rows): }{\code{"[n,]"} (right justified with
      whitespace padding)}
    \item{\code{k=2} (columns): }{\code{"[,n]"} (with \emph{no} whitespace
      padding)}
    \item{\code{k>2} (higher dims): }{\code{"n"}, i.e., the indices as
      \emph{character} values}
  }
  Setting \code{keepnums = FALSE} suppresses this behaviour.

  As \code{\link{data.frame}} subsetting (\sQuote{indexing}) keeps
  \code{\link{attributes}}, so do the \code{head()} and \code{tail()}
  methods for data frames.
}
\examples{
head(letters)
head(letters, n = -6L)

head(freeny.x, n = 10L)
head(freeny.y)

head(iris3)
head(iris3, c(6L, 2L))
head(iris3, c(6L, -1L, 2L))

tail(letters)
tail(letters, n = -6L)

tail(freeny.x)
## the bottom-right "corner" :
tail(freeny.x, n = c(4, 2))
tail(freeny.y)

tail(iris3)
tail(iris3, c(6L, 2L))
tail(iris3, c(6L, -1L, 2L))

## iris with dimnames stripped
a3d <- iris3 ; dimnames(a3d) <- NULL
tail(a3d, c(6, -1, 2)) # keepnums = TRUE is default here!
tail(a3d, c(6, -1, 2), keepnums = FALSE)

## data frame w/ a (non-standard) attribute:
treeS <- structure(trees, foo = "bar")
(n <- nrow(treeS))
stopifnot(exprs = { # attribute is kept
    identical(htS <- head(treeS), treeS[1:6, ])
    identical(attr(htS, "foo") , "bar")
    identical(tlS <- tail(treeS), treeS[(n-5):n, ])
    ## BUT if I use "useAttrib(.)", this is *not* ok, when n is of length 2:
    ## --- because [i,j]-indexing of data frames *also* drops "other" attributes ..
    identical(tail(treeS, 3:2), treeS[(n-2):n, 2:3] )
})

tail(library) # last lines of function

head(stats::ftable(Titanic))

## 1d-array (with named dim) :
a1 <- array(1:7, 7); names(dim(a1)) <- "O2"
stopifnot(exprs = {
  identical( tail(a1, 10), a1)
  identical( head(a1, 10), a1)
  identical( head(a1, 1), a1 [1 , drop=FALSE] ) # was a1[1] in R <= 3.6.x
  identical( tail(a1, 2), a1[6:7])
  identical( tail(a1, 1), a1 [7 , drop=FALSE] ) # was a1[7] in R <= 3.6.x
})
}
\author{
Patrick Burns, improved and corrected by R-Core. Negative argument
  added by Vincent Goulet.  Multi-dimension support added by Gabriel Becker.
}
