/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import fi.smaa.common.ValueRanker;
import fi.smaa.libror.FullValueFunction;
import fi.smaa.libror.GeneralValueFunctionSampler;
import fi.smaa.libror.UTAGMSSolver;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.RealMatrix;

public class RORSMAA
extends UTAGMSSolver {
    private static final int NR_ITERS = 10000;
    private GeneralValueFunctionSampler sampler;
    private RealMatrix poiMatrix;
    private RealMatrix raiMatrix;

    public RORSMAA(RealMatrix perfMatrix) {
        super(perfMatrix);
        this.sampler = new GeneralValueFunctionSampler(perfMatrix, 10000);
    }

    public GeneralValueFunctionSampler getSampler() {
        return this.sampler;
    }

    public void compute() {
        this.sampler.sample();
        int nrAlt = this.getNrAlternatives();
        double[] evals = new double[nrAlt];
        int[][] poiHits = new int[nrAlt][nrAlt];
        int[][] raiHits = new int[nrAlt][nrAlt];
        int[] ranks = new int[nrAlt];
        FullValueFunction[] fullValueFunctionArray = this.sampler.getValueFunctions();
        int n = fullValueFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            FullValueFunction vf = fullValueFunctionArray[n2];
            int i = 0;
            while (i < nrAlt) {
                evals[i] = vf.evaluate(this.perfMatrix.getRow(i));
                ++i;
            }
            i = 0;
            while (i < nrAlt) {
                int j = 0;
                while (j < nrAlt) {
                    if (evals[i] >= evals[j]) {
                        int[] nArray = poiHits[i];
                        int n3 = j;
                        nArray[n3] = nArray[n3] + 1;
                    }
                    ++j;
                }
                ++i;
            }
            ValueRanker.rankValues(evals, ranks);
            i = 0;
            while (i < nrAlt) {
                int[] nArray = raiHits[i];
                int n4 = ranks[i];
                nArray[n4] = nArray[n4] + 1;
                ++i;
            }
            ++n2;
        }
        this.poiMatrix = new Array2DRowRealMatrix(nrAlt, nrAlt);
        this.raiMatrix = new Array2DRowRealMatrix(nrAlt, nrAlt);
        double divider = this.sampler.getValueFunctions().length;
        int i = 0;
        while (i < nrAlt) {
            int j = 0;
            while (j < nrAlt) {
                this.poiMatrix.setEntry(i, j, (double)poiHits[i][j] / divider);
                this.raiMatrix.setEntry(i, j, (double)raiHits[i][j] / divider);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void addPreference(int a, int b) {
        super.addPreference(a, b);
        this.sampler.addPreference(a, b);
    }

    public RealMatrix getPOIs() {
        if (this.poiMatrix == null) {
            throw new IllegalStateException("compute() not called");
        }
        return this.poiMatrix;
    }

    public RealMatrix getRAIs() {
        if (this.raiMatrix == null) {
            throw new IllegalStateException("compute() not called");
        }
        return this.raiMatrix;
    }
}

