/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.libror;

import fi.smaa.common.ValueRanker;
import fi.smaa.libror.FullValueFunction;
import fi.smaa.libror.GeneralValueFunctionSampler;
import fi.smaa.libror.UTAGMSSolver;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.RealMatrix;

public class RORSMAA
extends UTAGMSSolver {
    private static final int NR_ITERS = 10000;
    private GeneralValueFunctionSampler sampler;
    private RealMatrix poiMatrix;
    private RealMatrix raiMatrix;

    public RORSMAA(RealMatrix perfMatrix) {
        super(perfMatrix);
        this.sampler = new GeneralValueFunctionSampler(perfMatrix, 10000);
    }

    public GeneralValueFunctionSampler getSampler() {
        return this.sampler;
    }

    public void compute() {
        this.sampler.sample();
        int nrAlt = this.getNrAlternatives();
        double[] evals = new double[nrAlt];
        int[][] poiHits = new int[nrAlt][nrAlt];
        int[][] raiHits = new int[nrAlt][nrAlt];
        int[] ranks = new int[nrAlt];
        for (FullValueFunction vf : this.sampler.getValueFunctions()) {
            int i;
            for (i = 0; i < nrAlt; ++i) {
                evals[i] = vf.evaluate(this.perfMatrix.getRow(i));
            }
            for (i = 0; i < nrAlt; ++i) {
                for (int j = 0; j < nrAlt; ++j) {
                    if (!(evals[i] >= evals[j])) continue;
                    int[] nArray = poiHits[i];
                    int n = j;
                    nArray[n] = nArray[n] + 1;
                }
            }
            ValueRanker.rankValues(evals, ranks);
            for (i = 0; i < nrAlt; ++i) {
                int[] nArray = raiHits[i];
                int n = ranks[i];
                nArray[n] = nArray[n] + 1;
            }
        }
        this.poiMatrix = new Array2DRowRealMatrix(nrAlt, nrAlt);
        this.raiMatrix = new Array2DRowRealMatrix(nrAlt, nrAlt);
        double divider = this.sampler.getValueFunctions().length;
        for (int i = 0; i < nrAlt; ++i) {
            for (int j = 0; j < nrAlt; ++j) {
                this.poiMatrix.setEntry(i, j, (double)poiHits[i][j] / divider);
                this.raiMatrix.setEntry(i, j, (double)raiHits[i][j] / divider);
            }
        }
    }

    public void addPreference(int a, int b) {
        super.addPreference(a, b);
        this.sampler.addPreference(a, b);
    }

    public RealMatrix getPOIs() {
        if (this.poiMatrix == null) {
            throw new IllegalStateException("compute() not called");
        }
        return this.poiMatrix;
    }

    public RealMatrix getRAIs() {
        if (this.raiMatrix == null) {
            throw new IllegalStateException("compute() not called");
        }
        return this.raiMatrix;
    }
}

