% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_multistar}
\alias{as_multistar}
\alias{as_multistar.star_database}
\title{Generate a \code{geomultistar::multistar} object}
\usage{
as_multistar(db)

\method{as_multistar}{star_database}(db)
}
\arguments{
\item{db}{A \code{star_database} object.}
}
\value{
A \code{geomultistar::multistar} object.
}
\description{
In order to be able to use the query and integration functions with geographic
information offered by the \code{geomultistar} package, we can obtain a \code{multistar}
object from a star database or a constellation.
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
ms1 <- db1 |>
  as_multistar()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", db1, db2)
ms <- ct |>
  as_multistar()

}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_csv_files}()},
\code{\link{as_dm_class}()},
\code{\link{as_rdb}()},
\code{\link{as_single_tibble_list}()},
\code{\link{as_tibble_list}()},
\code{\link{as_xlsx_file}()},
\code{\link{draw_tables}()}
}
\concept{star database exportation functions}
