% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3.R
\name{sendQuery}
\alias{sendQuery}
\title{Send SQL query to database.}
\usage{
sendQuery(db, statement, ...)
}
\arguments{
\item{db}{rocker object}

\item{statement}{SQL query (\code{SELECT})}

\item{...}{Optional, additional suitable parameters passed to \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}}
}
\value{
Invisible self
}
\description{
Send SQL query to database.
}
\examples{
db <- rocker::newDB()
rocker::setupSQLite(db)
rocker::connect(db)
rocker::writeTable(db, "mtcars", mtcars)
rocker::sendQuery(db, "SELECT * FROM mtcars;")
output <- rocker::fetch(db)
rocker::clearResult(db)
rocker::disconnect(db)
rocker::unloadDriver(db)
}
