% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_occurrences.R
\name{collapse_occurrences}
\alias{collapse_occurrences}
\title{Collapse the occurrences in utterances into groups}
\usage{
collapse_occurrences(
  parsedSource,
  collapseBy = "stanzaId",
  columns = NULL,
  logical = FALSE
)
}
\arguments{
\item{parsedSource}{The parsed sources as provided by \code{\link[=parse_source]{parse_source()}}.}

\item{collapseBy}{The column in the \code{sourceDf} (in the \code{parsedSource} object)
to collapse by (i.e. the column specifying the groups to collapse).}

\item{columns}{The columns to collapse; if unspecified (i.e. \code{NULL}), all
codes stored in the \code{code} object in the \code{codings} object in the
\code{parsedSource} object are taken (i.e. all used codes in the \code{parsedSource}
object).}

\item{logical}{Whether to return the counts of the occurrences (\code{FALSE}) or
simply whether any code occurreded in the group at all (\code{TRUE}).}
}
\value{
A dataframe with one row for each value of of \code{collapseBy} and columns
for \code{collapseBy} and each of the \code{columns}, with in the cells the counts (if
\code{logical} is \code{FALSE}) or \code{TRUE} or \code{FALSE} (if \code{logical} is \code{TRUE}).
}
\description{
This function collapses all occurrences into groups
sharing the same identifier, by default the \code{stanzaId}
identifier (\verb{[[sid=..]]}).
}
\examples{
### Get path to example source
exampleFile <-
  system.file("extdata", "example-1.rock", package="rock");

### Parse example source
parsedExample <-
  rock::parse_source(exampleFile);

### Collapse logically, using a code (either occurring or not):
collapsedExample <-
  rock::collapse_occurrences(parsedExample,
                             collapseBy = 'childCode1');

### Show result: only two rows left after collapsing,
### because 'childCode1' is either 0 or 1:
collapsedExample;

### Collapse using weights (i.e. count codes in each segment):
collapsedExample <-
  rock::collapse_occurrences(parsedExample,
                             collapseBy = 'childCode1',
                             logical=FALSE);


}
