% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_beta_boot}
\alias{o_beta_boot}
\title{Bootstrapped betas*}
\usage{
o_beta_boot(y, x, con, id = "none", time = "none", delta = 1, R2max, sim, obs, rep,
type, useed = NA, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent variable of interest (treatment variable; as string).}

\item{con}{Name of the other control variables. Provided as string in the format: "w + z +...".}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect models.}

\item{time}{Name of the time variable (e.g. year or month; as string). Only applicable for fixed effect models.}

\item{delta}{Delta for which beta* should be estimated (default is delta = 1).}

\item{R2max}{Max R-square for which beta* should be estimated.}

\item{sim}{Number of simulations.}

\item{obs}{Number of draws per simulation.}

\item{rep}{Bootstrapping either with (= TRUE) or without (= FALSE) replacement.}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{useed}{Seed number defined by user.}

\item{data}{Data.}
}
\value{
Returns tibble object. Including bootstrapped betas*.
}
\description{
Estimates bootstrapped betas*, i.e. the estimated bias-adjusted treatment effects, following Oster (2019).
}
\details{
Estimates bootstrapped betas*, i.e. the estimated bias-adjusted treatment effects, following Oster (2019). Bootstrapping can either be done with or without replacement. The function supports linear cross sectional (see \emph{lm} objects in R) and panel fixed effect (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate bootstrapped beta*
o_beta_boot(y = "mpg",                 # define the dependent variable name
                 x = "wt",             # define the main independent variable name
                 con = "hp + qsec",    # other control variables
                 delta = 1,            # define beta. This is usually set to 1
                 R2max = 0.9,          # define the max R-square.
                 sim = 100,            # define number of simulations
                 obs = 30,             # define number of drawn observations per simulation
                 rep = FALSE,          # define if bootstrapping is with or without replacement
                 type = "lm",          # define model type
                 useed = 123,          # define seed
                 data = data_oster)    # define dataset
}
\references{
Oster, E. (2019). Unobservable selection and coefficient stability: Theory and evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
