% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{reg_control}
\alias{reg_control}
\title{Tuning parameters for MM-regression}
\usage{
reg_control(efficiency = 0.85, max_iterations = 200, tol = 1e-07, seed = NULL)
}
\arguments{
\item{efficiency}{a numeric value giving the desired efficiency (defaults
to 0.85 for 85\% efficiency).}

\item{max_iterations}{an integer giving the maximum number of iterations in
various parts of the algorithm.}

\item{tol}{a small positive numeric value to be used to determine
convergence in various parts of the algorithm.}

\item{seed}{optional initial seed for the random number generator (see
\code{\link{.Random.seed}}).}
}
\value{
A list of tuning parameters as returned by
\code{\link[robustbase]{lmrob.control}()}.
}
\description{
Obtain a list with tuning paramters for \code{\link[robustbase]{lmrob}()}.
}
\note{
This is a simplified wrapper function for
\code{\link[robustbase]{lmrob.control}()}, as the latter requires detailed
knowledge of the MM-type regression algorithm.  Currently only 95\%, 90\%,
85\% (the default) and 80\% efficiency are supported.  For other values,
please specify the corresponding tuning parameters in
\code{\link[robustbase]{lmrob.control}()} directly.
}
\examples{
data("BSG2014")

# run fast-and-robust bootstrap test
ctrl <- reg_control(efficiency = 0.95)
boot <- test_mediation(BSG2014,
                       x = "ValueDiversity",
                       y = "TeamCommitment",
                       m = "TaskConflict",
                       level = 0.9,
                       control = ctrl)
summary(boot)

}
\references{
Salibian-Barrera, M. and Yohai, V.J. (2006) A Fast Algorithm for
S-regression Estimates. \emph{Journal of Computational and Graphical
Statistics}, \bold{15}(2), 414--427.  doi:10.1198/106186006x113629.

Yohai, V.J. (1987) High Breakdown-Point and High Efficiency Estimates for
Regression. \emph{The Annals of Statistics}, \bold{15}(20), 642--656.
doi:10.1214/aos/1176350366.
}
\seealso{
\code{\link[robustbase]{lmrob}()},
\code{\link[robustbase]{lmrob.control}()}
}
\author{
Andreas Alfons
}
\keyword{regression}
