% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mediation.R
\name{fit_mediation}
\alias{fit_mediation}
\alias{print.fit_mediation}
\alias{summary.reg_fit_mediation}
\alias{summary.cov_fit_mediation}
\alias{fit_mediation.formula}
\alias{fit_mediation.default}
\title{(Robustly) fit a mediation model}
\usage{
fit_mediation(object, ...)

\method{fit_mediation}{formula}(formula, data, ...)

\method{fit_mediation}{default}(
  object,
  x,
  y,
  m,
  covariates = NULL,
  method = c("regression", "covariance"),
  robust = TRUE,
  family = "gaussian",
  fit_yx = TRUE,
  control = NULL,
  ...
)
}
\arguments{
\item{object}{the first argument will determine the method of the generic
function to be dispatched.  For the default method, this should be a data
frame containing the variables.}

\item{\dots}{additional arguments to be passed down.  For the default
method, this can be used to specify tuning parameters directly instead
of via \code{control}.}

\item{formula}{an object of class "formula" (or one that can be coerced to
that class): a symbolic description of the model to be fitted.  Hypothesized
mediator variables should be wrapped in a call to \code{\link{m}()} (see
examples), and any optional control variables should be wrapped in a call to
\code{\link{covariates}()}.}

\item{data}{for the \code{formula} method, a data frame containing the
variables.}

\item{x}{a character string, an integer or a logical vector specifying the
column of \code{object} containing the independent variable.}

\item{y}{a character string, an integer or a logical vector specifying the
column of \code{object} containing the dependent variable.}

\item{m}{a character, integer or logical vector specifying the columns of
\code{object} containing the hypothesized mediator variables.}

\item{covariates}{optional; a character, integer or logical vector
specifying the columns of \code{object} containing additional covariates to
be used as control variables.}

\item{method}{a character string specifying the method of
estimation.  Possible values are \code{"regression"} (the default)
to estimate the effects via regressions, or \code{"covariance"} to
estimate the effects via the covariance matrix.  Note that the effects are
always estimated via regressions if more than one hypothesized mediator is
specified or if control variables are supplied.}

\item{robust}{a logical indicating whether to robustly estimate the effects
(defaults to \code{TRUE}).  For estimation via regressions
(\code{method = "regression"}), this can also be a character string, with
\code{"MM"} specifying the MM-estimator of regression, and \code{"median"}
specifying median regression.}

\item{family}{a character string specifying the error distribution to be
used in maximum likelihood estimation of regression models.  Possible values
are \code{"gaussian"} for a normal distribution (the default),
\code{skewnormal} for a skew-normal distribution, \code{"student"} for
Student's t distribution, \code{"skew-t"} for a skew-t distribution, or
\code{"select"} to select among these four distributions via BIC (see
\sQuote{Details}).  This is only relevant if \code{method = "regression"}
and \code{robust = FALSE}.}

\item{fit_yx}{a logical indicating whether to fit the regression model
\code{y ~ x + covariates} to estimate the total effect (the default is
\code{TRUE}).  This is only relevant if \code{method = "regression"} and
\code{robust = FALSE}.}

\item{control}{a list of tuning parameters for the corresponding robust
method.  For robust regression (\code{method = "regression"}, and
\code{robust = TRUE} or \code{robust = "MM"}), a list of tuning
parameters for \code{\link[robustbase]{lmrob}()} as generated by
\code{\link{reg_control}()}.  For Huberized covariance matrix estimation
(\code{method = "covariance"} and \code{robust = TRUE}), a list of tuning
parameters for \code{\link{cov_Huber}()} as generated by
\code{\link{cov_control}()}.  No tuning parameters are necessary for median
regression (\code{method = "regression"} and \code{robust = "median"}).}
}
\value{
An object inheriting from class \code{"fit_mediation"} (class
\code{"reg_fit_mediation"} if \code{method = "regression"} or
\code{"cov_fit_mediation"} if \code{method = "covariance"}) with
the following components:
\item{a}{a numeric vector containing the point estimates of the effect of
the independent variable on the proposed mediator variables.}
\item{b}{a numeric vector containing the point estimates of the direct
effect of the proposed mediator variables on the dependent variable.}
\item{direct}{numeric; the point estimate of the direct effect of the
independent variable on the dependent variable.}
\item{total}{numeric; the point estimate of the total effect of the
independent variable on the dependent variable.}
\item{ab}{a numeric vector containing the point estimates of the indirect
effects.}
\item{fit_mx}{an object of class \code{"\link[robustbase]{lmrob}"},
\code{"\link[stats]{lm}"} or \code{"lmse"} containing the estimation results
from the regression of the proposed mediator variable on the independent
variable, or a list of such objects in case of more than one hypothesized
mediator (only \code{"reg_fit_mediation"}).}
\item{fit_ymx}{an object of class \code{"\link[robustbase]{lmrob}"},
\code{"\link[stats]{lm}"} or \code{"lmse"} containing the estimation results
from the regression of the dependent variable on the proposed mediator and
independent variables (only \code{"reg_fit_mediation"}).}
\item{fit_yx}{an object of class \code{"\link[stats]{lm}"} or \code{"lmse"}
containing the estimation results from the regression of the dependent
variable on the independent variable (only \code{"reg_fit_mediation"} and
if \code{robust = FALSE}).}
\item{cov}{an object of class \code{"\link{cov_Huber}"} or
\code{"\link{cov_ML}"} containing the covariance matrix estimates
(only \code{"cov_fit_mediation"}).}
\item{x, y, m, covariates}{character vectors specifying the respective
variables used.}
\item{data}{a data frame containing the independent, dependent and
proposed mediator variables, as well as covariates.}
\item{robust}{either a logical indicating whether the effects were estimated
robustly, or one of the character strings \code{"MM"} and \code{"median"}
specifying the type of robust regressions.}
\item{control}{a list of tuning parameters used (if applicable).}
}
\description{
(Robustly) estimate the effects in a mediation model.
}
\details{
With \code{method = "regression"}, and \code{robust = TRUE} or
\code{robust = "MM"}, the effects are computed via the robust MM-estimator
of regression from \code{\link[robustbase]{lmrob}()}.  This is the default
behavior.

With \code{method = "regression"} and \code{robust = "median"}, the effects
are estimated via median regressions with \code{\link[quantreg]{rq}()}.
Unlike the robust MM-regressions above, median regressions are not robust
against outliers in the explanatory variables.

With \code{method = "regression"}, \code{robust = FALSE} and
\code{family = "select"}, the error distribution to be used in maximum
likelihood estimation of the regression models is selected via BIC.  The
following error distributions are included in the selection procedure: a
normal distribution, a skew-normal distribution, Student's t distribution,
and a skew-t distribution.  Note that the parameters of those distributions
are estimated as well.  The skew-normal and skew-t distributions thereby
use a centered parametrization such that the residuals are (approximately)
centered around 0.  Moreover, the skew-t distribution is only evaluated in
the selection procedure if both the skew-normal and Student's t distribution
yield an improvement in BIC over the normal distribution.  Otherwise the
estimation with a skew-t error distribution can be unstable.  Furthermore,
this saves a considerable amount of computation time in a bootstrap test,
as estimation with those error distributions is orders of magnitude slower
than any other estimation procedure in package \pkg{robmed}.

With \code{method = "covariance"} and \code{robust = TRUE}, the effects are
estimated based on a Huber M-estimator of location and scatter.  Note that
this covariance-based approach is less robust than the approach based on
robust MM-regressions described above.
}
\note{
The formula interface is still experimental and may change in future
versions.
}
\examples{
data("BSG2014")

# to reproduce results in paper
RNGversion("3.5.3")
seed <- 20150601

# formula interface
set.seed(seed)
fit1 <- fit_mediation(TeamCommitment ~ m(TaskConflict) + ValueDiversity,
                      data = BSG2014)
test1 <- test_mediation(fit1)
summary(test1)

# default method
set.seed(seed)
fit2 <- fit_mediation(BSG2014,
                      x = "ValueDiversity",
                      y = "TeamCommitment",
                      m = "TaskConflict")
test2 <- test_mediation(fit2)
summary(test2)

}
\references{
Alfons, A., Ates, N.Y. and Groenen, P.J.F. (2018) A robust bootstrap test
for mediation analysis.  \emph{ERIM Report Series in Management}, Erasmus
Research Institute of Management.  URL
\url{https://hdl.handle.net/1765/109594}.

Azzalini, A. and Arellano-Valle, R. B. (2013) Maximum penalized likelihood
estimation for skew-normal and skew-t distributions.  \emph{Journal of
Statistical Planning and Inference}, \bold{143}(2), 419--433.

Yuan, Y. and MacKinnon, D.P. (2014) Robust mediation analysis based on
median regression. \emph{Psychological Methods}, \bold{19}(1),
1--20.

Zu, J. and Yuan, K.-H. (2010) Local influence and robust procedures for
mediation analysis. \emph{Multivariate Behavioral Research}, \bold{45}(1),
1--44.
}
\seealso{
\code{\link{test_mediation}()}

\code{\link[robustbase]{lmrob}()}, \code{\link[stats]{lm}()},
\code{\link{cov_Huber}()}, \code{\link{cov_ML}()}
}
\author{
Andreas Alfons
}
\keyword{multivariate}
