% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBINFast.R
\name{robinCompareFast}
\alias{robinCompareFast}
\title{robinCompareFast}
\usage{
robinCompareFast(
  graph,
  method1 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "other"),
  method2 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "other"),
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  ncores = 2,
  FUN1 = NULL,
  FUN2 = NULL,
  directed = FALSE,
  weights = NULL,
  steps = 4,
  spins = 25,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10,
  verbose = TRUE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method1}{The first clustering method, one of "walktrap", 
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{method2}{The second custering method one of "walktrap",
"edgeBetweenness","fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{ncores}{number of CPU cores to use.(default is 2) For a faster 
execution we suggest to use ncores=(detectCores(logical = FALSE)-1)}

\item{FUN1}{personal designed function when method1 is "others". 
see \code{\link{methodCommunity}}.}

\item{FUN2}{personal designed function when method2 is "others". 
see \code{\link{methodCommunity}}.}

\item{directed}{This argument is settable only for "edgeBetweenness" method.}

\item{weights}{This argument is not settable for "infomap" method.}

\item{steps}{This argument is settable only for "leadingEigen"and"walktrap" 
method.}

\item{spins}{This argument is settable only for "infomap" method.}

\item{e.weights}{This argument is settable only for "infomap" method.}

\item{v.weights}{This argument is settable only for "infomap" method.}

\item{nb.trials}{This argument is settable only for "infomap" method.}

\item{verbose}{flag for verbose output (default as TRUE).}
}
\value{
A list object with two matrices:
- the matrix "Mean1" with the means of the procedure for the first method 
- the matrix "Mean2" with the means of the procedure for the second method
}
\description{
This function compares two community detection algorithms.
Is the parallelized and faster version of \code{\link{robinCompare}}
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
robinCompareFast(graph=graph, method1="louvain", 
method2="fastGreedy", measure="vi")
}
