% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau2.R
\name{tau2}
\alias{tau2}
\title{Compute the tau2 estimator of scale}
\usage{
tau2(x)
}
\arguments{
\item{x}{A vector of residuals.}
}
\value{
The tau2 estimate of scale.
}
\description{
The tau2-estimator is a robust measure of the scale. The exact formula of the estimator is in Crevits and Croux (2016), equation 3.10.
}
\examples{
set.seed(100)
e <- 10*rnorm(100)
mse <- mean(e^2) 
tse <- tau2(e) 
}
\references{
Crevits, R., and Croux, C (2016) "Forecasting with Robust Exponential Smoothing with Damped Trend and Seasonal Components".\emph{Working paper}. \url{https://doi.org/10.13140/RG.2.2.11791.18080}
}
