% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.pcaCoDa.R
\name{plot.pcaCoDa}
\alias{plot.pcaCoDa}
\title{Plot method}
\usage{
\method{plot}{pcaCoDa}(x, y, ..., which = 1, choices = 1:2)
}
\arguments{
\item{x}{object of class \sQuote{pcaCoDa}}

\item{y}{...}

\item{\dots}{...}

\item{which}{an integer between 1 and 3. Produces a screeplot (1), or a biplot using stats biplot.prcomp function (2), or a biplot using ggfortify's autoplot function (3).}

\item{choices}{principal components to plot by number}
}
\value{
The robust compositional screeplot.
}
\description{
Provides a screeplot and biplot for (robust) compositional principal components analysis.
}
\examples{

data(coffee)
\dontrun{
p1 <- pcaCoDa(coffee[,-1])
plot(p1)
plot(p1, type="lines")
plot(p1, which = 2)
plot(p1, which = 3)
}


}
\references{
Filzmoser, P., Hron, K., Reimann, C. (2009) Principal Component Analysis for
Compositional Data with Outliers. \emph{Environmetrics}, \bold{20} (6),
621--632.
}
\seealso{
\code{\link{pcaCoDa}}, \code{\link{biplot.pcaCoDa}}
}
\author{
M. Templ, K. Hron
}
\keyword{aplot}
