% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shower.R
\name{shower}
\alias{shower}
\title{R Markdown format for Shower presentations}
\usage{
shower(theme = c("ribbon", "material"), ratio = c("4x3", "16x10"),
  katex = FALSE, incremental = FALSE, fig_width = 8, fig_height = 4.9,
  fig_retina = if (!fig_caption) 2, fig_caption = FALSE, smart = TRUE,
  self_contained = TRUE, highlight = "default", template = "default",
  css = NULL, includes = NULL, keep_md = FALSE, lib_dir = NULL,
  pandoc_args = NULL, ...)
}
\arguments{
\item{theme}{Theme to use. The default theme is \sQuote{ribbon}.
The \sQuote{material} theme is an alternative.}

\item{ratio}{Slide ratio to use. It can be \sQuote{4x3} or
\sQuote{16x10}.}

\item{katex}{Whether to include KaTeX support. It is turned off
by default. See \url{https://github.com/Khan/KaTeX} for more
about KaTeX.}

\item{incremental}{\code{TRUE} to render slide bullets incrementally. Note
that if you want to reverse the default incremental behavior for an
individual bullet you can precede it with \code{>}. For example:
\emph{\code{> - Bullet Text}}}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2 when
\code{fig_caption} is \code{FALSE}, which currently works for all widely
used retina displays). Set to \code{NULL} to prevent retina scaling. Note
that this will always be \code{NULL} when \code{keep_md} is specified (this
is because \code{fig_retina} relies on outputting HTML directly into the
markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, --- to em-dashes, -- to en-dashes, and ... to
ellipses.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
it's size).}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso", "zenburn",
"haddock", and "textmate". Pass \code{NULL} to prevent syntax highlighting.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've created.
Note that if you don't use the "default" template then some features of
\code{html_document} won't be available (see the Templates section below for
more details).}

\item{css}{One or more css files to include}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\code{_files} appended to it.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Extra arguments, passed to \code{html_document_base}.}
}
\description{
Shower is a vanilla HTML/CSS/JS presentation engine.
}
\examples{
\dontrun{
rmarkdown::render("presentation.Rmd")
}
}
\seealso{
\url{https://github.com/shower/shower}
}

