% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enlarge_plot.R
\name{enlarge_plot}
\alias{enlarge_plot}
\title{Generate a small plot that will be enlarged in a modal when clicked}
\usage{
enlarge_plot(
  plot,
  large_plot = plot,
  plot_name = NULL,
  width_small = 2,
  height_small = 2,
  width_large = 7,
  height_large = 7,
  ...
)
}
\arguments{
\item{plot}{a plot}

\item{large_plot}{a larger version of the same plot. defaults to the first plot if left empty, but this only works for ggplot2 and similar, not base plots}

\item{plot_name}{optional: specify a meaningful plot name (needs to be unique in the document)}

\item{width_small}{width for the small plot}

\item{height_small}{height for the small plot}

\item{width_large}{width for the large plot}

\item{height_large}{height for the large plot}

\item{...}{passed to \code{\link[=partial]{partial()}}}
}
\value{
Returns markdown/HTML text with class "knit_asis"
}
\description{
Generate a small plot that will be enlarged in a modal when clicked
}
\examples{
\dontrun{
if(!requireNamespace("pkgdown", quietly = TRUE) || !pkgdown::in_pkgdown()) {
# will generate files in a temporary directory
if (requireNamespace("ggplot2")) {
dist <- ggplot2::qplot(stats::rbeta(200, 3, 4))
enlarge_plot(dist,
large_plot = dist + ggplot2::theme_classic(base_size = 18))
} else {
graphics::hist(stats::rbeta(200, 3, 4))
dist <- grDevices::recordPlot()
enlarge_plot(dist)
}
}
}
}
