/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier;

import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.classifier.Prediction;
import dmLab.utils.cmatrix.ConfusionMatrix;
import dmLab.utils.cmatrix.QualityMeasure;

public final class PredictionResult {
    public ConfusionMatrix confusionMatrix;
    public Prediction[] predictions;
    private int type;

    /*
     * WARNING - void declaration
     */
    public PredictionResult(int type) {
        void var1_1;
        this.type = var1_1;
    }

    public final double getPredQuality() {
        if (this.type == Classifier.MODEL_CLASSIFIER) {
            return this.getPredQuality(QualityMeasure.WACC);
        }
        if (this.type == Classifier.MODEL_PREDICTOR) {
            return this.getPredQuality(QualityMeasure.PEARSON);
        }
        return Double.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final double getPredQuality(int measure) {
        void var1_1;
        if (this.type == Classifier.MODEL_CLASSIFIER) {
            if (measure == QualityMeasure.WACC) {
                return QualityMeasure.calcWAcc(this.confusionMatrix.getMatrix());
            }
            if (measure == QualityMeasure.ACC) {
                return QualityMeasure.calcAcc(this.confusionMatrix.getMatrix());
            }
            return Double.NaN;
        }
        double[] x = new double[this.predictions.length];
        double[] y = new double[this.predictions.length];
        int i = 0;
        while (i < x.length) {
            x[i] = this.predictions[i].getRealValue();
            y[i] = this.predictions[i].getPredictedValue();
            ++i;
        }
        if (measure == QualityMeasure.PEARSON) {
            return DiscFunctions.pearson(x, y);
        }
        if (measure == QualityMeasure.MAE) {
            return DiscFunctions.mae(x, y);
        }
        if (measure == QualityMeasure.RMSE) {
            return DiscFunctions.rmse(x, y);
        }
        if (var1_1 == QualityMeasure.SMAPE) {
            void var3_3;
            void var2_2;
            return DiscFunctions.smape((double[])var2_2, (double[])var3_3);
        }
        return Double.NaN;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        if (this.type == Classifier.MODEL_PREDICTOR && this.predictions != null) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("Pearson Correlation: " + this.getPredQuality(QualityMeasure.PEARSON)).append("\n");
            tmp.append("MAE: " + this.getPredQuality(QualityMeasure.MAE)).append("\n");
            tmp.append("RMSE: " + this.getPredQuality(QualityMeasure.RMSE)).append("\n");
            tmp.append("SMAPE: " + this.getPredQuality(QualityMeasure.SMAPE)).append("\n");
            return tmp.toString();
        }
        if (this.type == Classifier.MODEL_CLASSIFIER && this.confusionMatrix != null) {
            void var1_2;
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.confusionMatrix.toString(true, true, false, "\t"));
            tmp.append(this.confusionMatrix.statsToString(4, true));
            return var1_2.toString();
        }
        return "";
    }
}

