/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.PriorityQueue;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.DistanceFunction;
import weka.core.Drawable;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;

public class HierarchicalClusterer
extends AbstractClusterer
implements OptionHandler,
CapabilitiesHandler,
Drawable {
    private static final long serialVersionUID = 1L;
    protected boolean m_bDebug = false;
    protected boolean m_bDistanceIsBranchLength = false;
    Instances m_instances;
    int m_nNumClusters = 2;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();
    static final int SINGLE = 0;
    static final int COMPLETE = 1;
    static final int AVERAGE = 2;
    static final int MEAN = 3;
    static final int CENTROID = 4;
    static final int WARD = 5;
    static final int ADJCOMLPETE = 6;
    static final int NEIGHBOR_JOINING = 7;
    public static final Tag[] TAGS_LINK_TYPE = new Tag[]{new Tag(0, "SINGLE"), new Tag(1, "COMPLETE"), new Tag(2, "AVERAGE"), new Tag(3, "MEAN"), new Tag(4, "CENTROID"), new Tag(5, "WARD"), new Tag(6, "ADJCOMLPETE"), new Tag(7, "NEIGHBOR_JOINING")};
    int m_nLinkType = 0;
    boolean m_bPrintNewick = true;
    Node[] m_clusters;
    int[] m_nClusterNr;

    public void setNumClusters(int nClusters) {
        this.m_nNumClusters = Math.max(1, nClusters);
    }

    public int getNumClusters() {
        return this.m_nNumClusters;
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) {
        this.m_DistanceFunction = distanceFunction;
    }

    public boolean getPrintNewick() {
        return this.m_bPrintNewick;
    }

    public void setPrintNewick(boolean bPrintNewick) {
        this.m_bPrintNewick = bPrintNewick;
    }

    public void setLinkType(SelectedTag newLinkType) {
        if (newLinkType.getTags() == TAGS_LINK_TYPE) {
            this.m_nLinkType = newLinkType.getSelectedTag().getID();
        }
    }

    public SelectedTag getLinkType() {
        return new SelectedTag(this.m_nLinkType, TAGS_LINK_TYPE);
    }

    @Override
    public void buildClusterer(Instances data) throws Exception {
        this.m_instances = data;
        int nInstances = this.m_instances.numInstances();
        if (nInstances == 0) {
            return;
        }
        this.m_DistanceFunction.setInstances(this.m_instances);
        Vector[] nClusterID = new Vector[data.numInstances()];
        int i = 0;
        while (i < data.numInstances()) {
            nClusterID[i] = new Vector();
            nClusterID[i].add(i);
            ++i;
        }
        int nClusters = data.numInstances();
        Node[] clusterNodes = new Node[nInstances];
        if (this.m_nLinkType == 7) {
            this.neighborJoining(nClusters, nClusterID, clusterNodes);
        } else {
            this.doLinkClustering(nClusters, nClusterID, clusterNodes);
        }
        int iCurrent = 0;
        this.m_clusters = new Node[this.m_nNumClusters];
        this.m_nClusterNr = new int[nInstances];
        int i2 = 0;
        while (i2 < nInstances) {
            if (nClusterID[i2].size() > 0) {
                int j = 0;
                while (j < nClusterID[i2].size()) {
                    this.m_nClusterNr[((Integer)nClusterID[i2].elementAt((int)j)).intValue()] = iCurrent;
                    ++j;
                }
                this.m_clusters[iCurrent] = clusterNodes[i2];
                ++iCurrent;
            }
            ++i2;
        }
    }

    void neighborJoining(int nClusters, Vector<Integer>[] nClusterID, Node[] clusterNodes) {
        int n = this.m_instances.numInstances();
        double[][] fDist = new double[nClusters][nClusters];
        int i = 0;
        while (i < nClusters) {
            fDist[i][i] = 0.0;
            int j = i + 1;
            while (j < nClusters) {
                fDist[i][j] = this.getDistance0(nClusterID[i], nClusterID[j]);
                fDist[j][i] = fDist[i][j];
                ++j;
            }
            ++i;
        }
        double[] fSeparationSums = new double[n];
        double[] fSeparations = new double[n];
        int[] nNextActive = new int[n];
        int i2 = 0;
        while (i2 < n) {
            double fSum = 0.0;
            int j = 0;
            while (j < n) {
                fSum += fDist[i2][j];
                ++j;
            }
            fSeparationSums[i2] = fSum;
            fSeparations[i2] = fSum / (double)(nClusters - 2);
            nNextActive[i2] = i2 + 1;
            ++i2;
        }
        while (nClusters > 2) {
            double fSep2;
            double fVal;
            double fSep1;
            int i3;
            int iMin1 = -1;
            int iMin2 = -1;
            double fMin = Double.MAX_VALUE;
            if (this.m_bDebug) {
                i3 = 0;
                while (i3 < n) {
                    if (nClusterID[i3].size() > 0) {
                        double[] fRow = fDist[i3];
                        fSep1 = fSeparations[i3];
                        int j = 0;
                        while (j < n) {
                            if (nClusterID[j].size() > 0 && i3 != j && (fVal = fRow[j] - fSep1 - (fSep2 = fSeparations[j])) < fMin) {
                                iMin1 = i3;
                                iMin2 = j;
                                fMin = fVal;
                            }
                            ++j;
                        }
                    }
                    ++i3;
                }
            } else {
                i3 = 0;
                while (i3 < n) {
                    double fSep12 = fSeparations[i3];
                    double[] fRow = fDist[i3];
                    int j = nNextActive[i3];
                    while (j < n) {
                        fSep2 = fSeparations[j];
                        fVal = fRow[j] - fSep12 - fSep2;
                        if (fVal < fMin) {
                            iMin1 = i3;
                            iMin2 = j;
                            fMin = fVal;
                        }
                        j = nNextActive[j];
                    }
                    i3 = nNextActive[i3];
                }
            }
            double fMinDistance = fDist[iMin1][iMin2];
            fSep1 = fSeparations[iMin1];
            double fSep22 = fSeparations[iMin2];
            double fDist1 = 0.5 * fMinDistance + 0.5 * (fSep1 - fSep22);
            double fDist2 = 0.5 * fMinDistance + 0.5 * (fSep22 - fSep1);
            if (--nClusters > 2) {
                double fNewSeparationSum = 0.0;
                double fMutualDistance = fDist[iMin1][iMin2];
                double[] fRow1 = fDist[iMin1];
                double[] fRow2 = fDist[iMin2];
                int i4 = 0;
                while (i4 < n) {
                    if (i4 == iMin1 || i4 == iMin2 || nClusterID[i4].size() == 0) {
                        fRow1[i4] = 0.0;
                    } else {
                        double fVal1 = fRow1[i4];
                        double fVal2 = fRow2[i4];
                        double fDistance = (fVal1 + fVal2 - fMutualDistance) / 2.0;
                        fNewSeparationSum += fDistance;
                        int n2 = i4;
                        fSeparationSums[n2] = fSeparationSums[n2] + (fDistance - fVal1 - fVal2);
                        fSeparations[i4] = fSeparationSums[i4] / (double)(nClusters - 2);
                        fRow1[i4] = fDistance;
                        fDist[i4][iMin1] = fDistance;
                    }
                    ++i4;
                }
                fSeparationSums[iMin1] = fNewSeparationSum;
                fSeparations[iMin1] = fNewSeparationSum / (double)(nClusters - 2);
                fSeparationSums[iMin2] = 0.0;
                this.merge(iMin1, iMin2, fDist1, fDist2, nClusterID, clusterNodes);
                int iPrev = iMin2;
                while (nClusterID[iPrev].size() == 0) {
                    --iPrev;
                }
                nNextActive[iPrev] = nNextActive[iMin2];
                continue;
            }
            this.merge(iMin1, iMin2, fDist1, fDist2, nClusterID, clusterNodes);
            break;
        }
        i2 = 0;
        while (i2 < n) {
            if (nClusterID[i2].size() > 0) {
                int j = i2 + 1;
                while (j < n) {
                    if (nClusterID[j].size() > 0) {
                        double fDist1 = fDist[i2][j];
                        if (nClusterID[i2].size() == 1) {
                            this.merge(i2, j, fDist1, 0.0, nClusterID, clusterNodes);
                            break;
                        }
                        if (nClusterID[j].size() == 1) {
                            this.merge(i2, j, 0.0, fDist1, nClusterID, clusterNodes);
                            break;
                        }
                        this.merge(i2, j, fDist1 / 2.0, fDist1 / 2.0, nClusterID, clusterNodes);
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
    }

    void doLinkClustering(int nClusters, Vector<Integer>[] nClusterID, Node[] clusterNodes) {
        int nInstances = this.m_instances.numInstances();
        PriorityQueue<Tuple> queue = new PriorityQueue<Tuple>(nClusters * nClusters / 2, new TupleComparator());
        double[][] fDistance0 = new double[nClusters][nClusters];
        double[][] fClusterDistance = null;
        if (this.m_bDebug) {
            fClusterDistance = new double[nClusters][nClusters];
        }
        int i = 0;
        while (i < nClusters) {
            fDistance0[i][i] = 0.0;
            int j = i + 1;
            while (j < nClusters) {
                fDistance0[i][j] = this.getDistance0(nClusterID[i], nClusterID[j]);
                fDistance0[j][i] = fDistance0[i][j];
                queue.add(new Tuple(fDistance0[i][j], i, j, 1, 1));
                if (this.m_bDebug) {
                    fClusterDistance[i][j] = fDistance0[i][j];
                    fClusterDistance[j][i] = fDistance0[i][j];
                }
                ++j;
            }
            ++i;
        }
        while (nClusters > this.m_nNumClusters) {
            int iMin1 = -1;
            int iMin2 = -1;
            if (this.m_bDebug) {
                double fMinDistance = Double.MAX_VALUE;
                int i2 = 0;
                while (i2 < nInstances) {
                    if (nClusterID[i2].size() > 0) {
                        int j = i2 + 1;
                        while (j < nInstances) {
                            double fDist;
                            if (nClusterID[j].size() > 0 && (fDist = fClusterDistance[i2][j]) < fMinDistance) {
                                fMinDistance = fDist;
                                iMin1 = i2;
                                iMin2 = j;
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
                this.merge(iMin1, iMin2, fMinDistance, fMinDistance, nClusterID, clusterNodes);
            } else {
                Tuple t;
                while ((t = queue.poll()) != null && (nClusterID[t.m_iCluster1].size() != t.m_nClusterSize1 || nClusterID[t.m_iCluster2].size() != t.m_nClusterSize2)) {
                }
                iMin1 = t.m_iCluster1;
                iMin2 = t.m_iCluster2;
                this.merge(iMin1, iMin2, t.m_fDist, t.m_fDist, nClusterID, clusterNodes);
            }
            int i3 = 0;
            while (i3 < nInstances) {
                if (i3 != iMin1 && nClusterID[i3].size() != 0) {
                    int i1 = Math.min(iMin1, i3);
                    int i2 = Math.max(iMin1, i3);
                    double fDistance = this.getDistance(fDistance0, nClusterID[i1], nClusterID[i2]);
                    if (this.m_bDebug) {
                        fClusterDistance[i1][i2] = fDistance;
                        fClusterDistance[i2][i1] = fDistance;
                    }
                    queue.add(new Tuple(fDistance, i1, i2, nClusterID[i1].size(), nClusterID[i2].size()));
                }
                ++i3;
            }
            --nClusters;
        }
    }

    void merge(int iMin1, int iMin2, double fDist1, double fDist2, Vector<Integer>[] nClusterID, Node[] clusterNodes) {
        if (this.m_bDebug) {
            System.err.println("Merging " + iMin1 + " " + iMin2 + " " + fDist1 + " " + fDist2);
        }
        if (iMin1 > iMin2) {
            int h = iMin1;
            iMin1 = iMin2;
            iMin2 = h;
            double f = fDist1;
            fDist1 = fDist2;
            fDist2 = f;
        }
        nClusterID[iMin1].addAll(nClusterID[iMin2]);
        nClusterID[iMin2].removeAllElements();
        Node node = new Node();
        if (clusterNodes[iMin1] == null) {
            node.m_iLeftInstance = iMin1;
        } else {
            node.m_left = clusterNodes[iMin1];
            clusterNodes[iMin1].m_parent = node;
        }
        if (clusterNodes[iMin2] == null) {
            node.m_iRightInstance = iMin2;
        } else {
            node.m_right = clusterNodes[iMin2];
            clusterNodes[iMin2].m_parent = node;
        }
        if (this.m_bDistanceIsBranchLength) {
            node.setLength(fDist1, fDist2);
        } else {
            node.setHeight(fDist1, fDist2);
        }
        clusterNodes[iMin1] = node;
    }

    double getDistance0(Vector<Integer> cluster1, Vector<Integer> cluster2) {
        double fBestDist = Double.MAX_VALUE;
        switch (this.m_nLinkType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                Instance instance1 = (Instance)this.m_instances.instance(cluster1.elementAt(0)).copy();
                Instance instance2 = (Instance)this.m_instances.instance(cluster2.elementAt(0)).copy();
                fBestDist = this.m_DistanceFunction.distance(instance1, instance2);
                break;
            }
            case 5: {
                double ESS1 = this.calcESS(cluster1);
                double ESS2 = this.calcESS(cluster2);
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                double ESS = this.calcESS(merged);
                fBestDist = ESS * (double)merged.size() - ESS1 * (double)cluster1.size() - ESS2 * (double)cluster2.size();
            }
        }
        return fBestDist;
    }

    double getDistance(double[][] fDistance, Vector<Integer> cluster1, Vector<Integer> cluster2) {
        double fBestDist = Double.MAX_VALUE;
        switch (this.m_nLinkType) {
            case 0: {
                fBestDist = Double.MAX_VALUE;
                int i = 0;
                while (i < cluster1.size()) {
                    int i1 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i2 = cluster2.elementAt(j);
                        double fDist = fDistance[i1][i2];
                        if (fBestDist > fDist) {
                            fBestDist = fDist;
                        }
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case 1: 
            case 6: {
                double fDist;
                int i2;
                int i1;
                fBestDist = 0.0;
                int i = 0;
                while (i < cluster1.size()) {
                    int i12 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i22 = cluster2.elementAt(j);
                        double fDist2 = fDistance[i12][i22];
                        if (fBestDist < fDist2) {
                            fBestDist = fDist2;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (this.m_nLinkType == 1) break;
                double fMaxDist = 0.0;
                int i3 = 0;
                while (i3 < cluster1.size()) {
                    i1 = cluster1.elementAt(i3);
                    int j = i3 + 1;
                    while (j < cluster1.size()) {
                        i2 = cluster1.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (fMaxDist < fDist) {
                            fMaxDist = fDist;
                        }
                        ++j;
                    }
                    ++i3;
                }
                i3 = 0;
                while (i3 < cluster2.size()) {
                    i1 = cluster2.elementAt(i3);
                    int j = i3 + 1;
                    while (j < cluster2.size()) {
                        i2 = cluster2.elementAt(j);
                        fDist = fDistance[i1][i2];
                        if (fMaxDist < fDist) {
                            fMaxDist = fDist;
                        }
                        ++j;
                    }
                    ++i3;
                }
                fBestDist -= fMaxDist;
                break;
            }
            case 2: {
                fBestDist = 0.0;
                int i = 0;
                while (i < cluster1.size()) {
                    int i1 = cluster1.elementAt(i);
                    int j = 0;
                    while (j < cluster2.size()) {
                        int i2 = cluster2.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                        ++j;
                    }
                    ++i;
                }
                fBestDist /= (double)(cluster1.size() * cluster2.size());
                break;
            }
            case 3: {
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                fBestDist = 0.0;
                int i = 0;
                while (i < merged.size()) {
                    int i1 = (Integer)merged.elementAt(i);
                    int j = i + 1;
                    while (j < merged.size()) {
                        int i2 = (Integer)merged.elementAt(j);
                        fBestDist += fDistance[i1][i2];
                        ++j;
                    }
                    ++i;
                }
                int n = merged.size();
                fBestDist /= (double)n * ((double)n - 1.0) / 2.0;
                break;
            }
            case 4: {
                int j;
                double[] fValues1 = new double[this.m_instances.numAttributes()];
                int i = 0;
                while (i < cluster1.size()) {
                    Instance instance = this.m_instances.instance(cluster1.elementAt(i));
                    int j2 = 0;
                    while (j2 < this.m_instances.numAttributes()) {
                        int n = j2;
                        fValues1[n] = fValues1[n] + instance.value(j2);
                        ++j2;
                    }
                    ++i;
                }
                double[] fValues2 = new double[this.m_instances.numAttributes()];
                int i4 = 0;
                while (i4 < cluster2.size()) {
                    Instance instance = this.m_instances.instance(cluster2.elementAt(i4));
                    j = 0;
                    while (j < this.m_instances.numAttributes()) {
                        int n = j;
                        fValues2[n] = fValues2[n] + instance.value(j);
                        ++j;
                    }
                    ++i4;
                }
                int j3 = 0;
                while (j3 < this.m_instances.numAttributes()) {
                    int n = j3;
                    fValues1[n] = fValues1[n] / (double)cluster1.size();
                    int n2 = j3++;
                    fValues2[n2] = fValues2[n2] / (double)cluster2.size();
                }
                Instance instance1 = (Instance)this.m_instances.instance(0).copy();
                Instance instance2 = (Instance)this.m_instances.instance(0).copy();
                j = 0;
                while (j < this.m_instances.numAttributes()) {
                    instance1.setValue(j, fValues1[j]);
                    instance2.setValue(j, fValues2[j]);
                    ++j;
                }
                fBestDist = this.m_DistanceFunction.distance(instance1, instance2);
                break;
            }
            case 5: {
                double ESS1 = this.calcESS(cluster1);
                double ESS2 = this.calcESS(cluster2);
                Vector<Integer> merged = new Vector<Integer>();
                merged.addAll(cluster1);
                merged.addAll(cluster2);
                double ESS = this.calcESS(merged);
                fBestDist = ESS * (double)merged.size() - ESS1 * (double)cluster1.size() - ESS2 * (double)cluster2.size();
            }
        }
        return fBestDist;
    }

    double calcESS(Vector<Integer> cluster) {
        double[] fValues1 = new double[this.m_instances.numAttributes()];
        int i = 0;
        while (i < cluster.size()) {
            Instance instance = this.m_instances.instance(cluster.elementAt(i));
            int j = 0;
            while (j < this.m_instances.numAttributes()) {
                int n = j;
                fValues1[n] = fValues1[n] + instance.value(j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.m_instances.numAttributes()) {
            int n = j++;
            fValues1[n] = fValues1[n] / (double)cluster.size();
        }
        Instance centroid = (Instance)this.m_instances.instance(cluster.elementAt(0)).copy();
        int j2 = 0;
        while (j2 < this.m_instances.numAttributes()) {
            centroid.setValue(j2, fValues1[j2]);
            ++j2;
        }
        double fESS = 0.0;
        int i2 = 0;
        while (i2 < cluster.size()) {
            Instance instance = this.m_instances.instance(cluster.elementAt(i2));
            fESS += this.m_DistanceFunction.distance(centroid, instance);
            ++i2;
        }
        return fESS / (double)cluster.size();
    }

    @Override
    public int clusterInstance(Instance instance) throws Exception {
        if (this.m_instances.numInstances() == 0) {
            return 0;
        }
        double fBestDist = Double.MAX_VALUE;
        int iBestInstance = -1;
        int i = 0;
        while (i < this.m_instances.numInstances()) {
            double fDist = this.m_DistanceFunction.distance(instance, this.m_instances.instance(i));
            if (fDist < fBestDist) {
                fBestDist = fDist;
                iBestInstance = i;
            }
            ++i;
        }
        return this.m_nClusterNr[iBestInstance];
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (this.numberOfClusters() == 0) {
            double[] p = new double[]{1.0};
            return p;
        }
        double[] p = new double[this.numberOfClusters()];
        p[this.clusterInstance((Instance)instance)] = 1.0;
        return p;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.disableAll();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public int numberOfClusters() throws Exception {
        return Math.min(this.m_nNumClusters, this.m_instances.numInstances());
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tIf set, classifier is run in debug mode and\n\tmay output additional info to the console", "D", 0, "-D"));
        newVector.addElement(new Option("\tIf set, distance is interpreted as branch length\n\totherwise it is node height.", "B", 0, "-B"));
        newVector.addElement(new Option("\tnumber of clusters", "N", 1, "-N <Nr Of Clusters>"));
        newVector.addElement(new Option("\tFlag to indicate the cluster should be printed in Newick format.", "P", 0, "-P"));
        newVector.addElement(new Option("Link type (Single, Complete, Average, Mean, Centroid, Ward, Adjusted complete, Neighbor joining)", "L", 1, "-L [SINGLE|COMPLETE|AVERAGE|MEAN|CENTROID|WARD|ADJCOMLPETE|NEIGHBOR_JOINING]"));
        newVector.add(new Option("\tDistance function to use.\n\t(default: weka.core.EuclideanDistance)", "A", 1, "-A <classname and options>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String nnSearchClass;
        this.m_bPrintNewick = Utils.getFlag('P', options);
        String optionString = Utils.getOption('N', options);
        if (optionString.length() != 0) {
            Integer temp = new Integer(optionString);
            this.setNumClusters(temp);
        } else {
            this.setNumClusters(2);
        }
        this.setDebug(Utils.getFlag('D', options));
        this.setDistanceIsBranchLength(Utils.getFlag('B', options));
        String sLinkType = Utils.getOption('L', options);
        if (sLinkType.compareTo("SINGLE") == 0) {
            this.setLinkType(new SelectedTag(0, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("COMPLETE") == 0) {
            this.setLinkType(new SelectedTag(1, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("AVERAGE") == 0) {
            this.setLinkType(new SelectedTag(2, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("MEAN") == 0) {
            this.setLinkType(new SelectedTag(3, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("CENTROID") == 0) {
            this.setLinkType(new SelectedTag(4, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("WARD") == 0) {
            this.setLinkType(new SelectedTag(5, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("ADJCOMLPETE") == 0) {
            this.setLinkType(new SelectedTag(6, TAGS_LINK_TYPE));
        }
        if (sLinkType.compareTo("NEIGHBOR_JOINING") == 0) {
            this.setLinkType(new SelectedTag(7, TAGS_LINK_TYPE));
        }
        if ((nnSearchClass = Utils.getOption('A', options)).length() != 0) {
            String[] nnSearchClassSpec = Utils.splitOptions(nnSearchClass);
            if (nnSearchClassSpec.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String className = nnSearchClassSpec[0];
            nnSearchClassSpec[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, className, nnSearchClassSpec));
        } else {
            this.setDistanceFunction(new EuclideanDistance());
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[14];
        int current = 0;
        options[current++] = "-N";
        options[current++] = "" + this.getNumClusters();
        options[current++] = "-L";
        switch (this.m_nLinkType) {
            case 0: {
                options[current++] = "SINGLE";
                break;
            }
            case 1: {
                options[current++] = "COMPLETE";
                break;
            }
            case 2: {
                options[current++] = "AVERAGE";
                break;
            }
            case 3: {
                options[current++] = "MEAN";
                break;
            }
            case 4: {
                options[current++] = "CENTROID";
                break;
            }
            case 5: {
                options[current++] = "WARD";
                break;
            }
            case 6: {
                options[current++] = "ADJCOMLPETE";
                break;
            }
            case 7: {
                options[current++] = "NEIGHBOR_JOINING";
            }
        }
        if (this.m_bPrintNewick) {
            options[current++] = "-P";
        }
        if (this.getDebug()) {
            options[current++] = "-D";
        }
        if (this.getDistanceIsBranchLength()) {
            options[current++] = "-B";
        }
        options[current++] = "-A";
        options[current++] = (String.valueOf(this.m_DistanceFunction.getClass().getName()) + " " + Utils.joinOptions(this.m_DistanceFunction.getOptions())).trim();
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int attIndex = this.m_instances.classIndex();
        if (attIndex < 0) {
            attIndex = 0;
            while (attIndex < this.m_instances.numAttributes() - 1) {
                if (this.m_instances.attribute(attIndex).isString()) break;
                ++attIndex;
            }
        }
        try {
            if (this.m_bPrintNewick && this.numberOfClusters() > 0) {
                int i = 0;
                while (i < this.m_clusters.length) {
                    if (this.m_clusters[i] != null) {
                        buf.append("Cluster " + i + "\n");
                        if (this.m_instances.attribute(attIndex).isString()) {
                            buf.append(this.m_clusters[i].toString(attIndex));
                        } else {
                            buf.append(this.m_clusters[i].toString2(attIndex));
                        }
                        buf.append("\n\n");
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    public void setDebug(boolean debug) {
        this.m_bDebug = debug;
    }

    public boolean getDebug() {
        return this.m_bDebug;
    }

    public boolean getDistanceIsBranchLength() {
        return this.m_bDistanceIsBranchLength;
    }

    public void setDistanceIsBranchLength(boolean bDistanceIsHeight) {
        this.m_bDistanceIsBranchLength = bDistanceIsHeight;
    }

    public String distanceIsBranchLengthTipText() {
        return "If set to false, the distance between clusters is interpreted as the height of the node linking the clusters. This is appropriate for example for single link clustering. However, for neighbor joining, the distance is better interpreted as branch length. Set this flag to get the latter interpretation.";
    }

    public String debugTipText() {
        return "If set to true, classifier may output additional info to the console.";
    }

    public String numClustersTipText() {
        return "Sets the number of clusters. If a single hierarchy is desired, set this to 1.";
    }

    public String printNewickTipText() {
        return "Flag to indicate whether the cluster should be print in Newick format. This can be useful for display in other programs. However, for large datasets a lot of text may be produced, which may not be a nuisance when the Newick format is not required";
    }

    public String distanceFunctionTipText() {
        return "Sets the distance function, which measures the distance between two individual. instances (or possibly the distance between an instance and the centroid of a clusterdepending on the Link type).";
    }

    public String linkTypeTipText() {
        return "Sets the method used to measure the distance between two clusters.\nSINGLE:\n find single link distance aka minimum link, which is the closest distance between any item in cluster1 and any item in cluster2\nCOMPLETE:\n find complete link distance aka maximum link, which is the largest distance between any item in cluster1 and any item in cluster2\nADJCOMLPETE:\n as COMPLETE, but with adjustment, which is the largest within cluster distance\nAVERAGE:\n finds average distance between the elements of the two clusters\nMEAN: \n calculates the mean distance of a merged cluster (akak Group-average agglomerative clustering)\nCENTROID:\n finds the distance of the centroids of the clusters\nWARD:\n finds the distance of the change in caused by merging the cluster. The information of a cluster is calculated as the error sum of squares of the centroids of the cluster and its members.\nNEIGHBOR_JOINING\n use neighbor joining algorithm.";
    }

    public String globalInfo() {
        return "Hierarchical clustering class.\nImplements a number of classic agglomorative (i.e. bottom up) hierarchical clustering methodsbased on .";
    }

    public static void main(String[] argv) {
        HierarchicalClusterer.runClusterer(new HierarchicalClusterer(), argv);
    }

    @Override
    public String graph() throws Exception {
        if (this.numberOfClusters() == 0) {
            return "Newick:(no,clusters)";
        }
        int attIndex = this.m_instances.classIndex();
        if (attIndex < 0) {
            attIndex = 0;
            while (attIndex < this.m_instances.numAttributes() - 1) {
                if (this.m_instances.attribute(attIndex).isString()) break;
                ++attIndex;
            }
        }
        String sNewick = null;
        sNewick = this.m_instances.attribute(attIndex).isString() ? this.m_clusters[0].toString(attIndex) : this.m_clusters[0].toString2(attIndex);
        return "Newick:" + sNewick;
    }

    @Override
    public int graphType() {
        return 3;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6592 $");
    }

    class Node
    implements Serializable {
        Node m_left;
        Node m_right;
        Node m_parent;
        int m_iLeftInstance;
        int m_iRightInstance;
        double m_fLeftLength = 0.0;
        double m_fRightLength = 0.0;
        double m_fHeight = 0.0;

        Node() {
        }

        public String toString(int attIndex) {
            DecimalFormat myFormatter = new DecimalFormat("#.#####");
            if (this.m_left == null) {
                if (this.m_right == null) {
                    return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).stringValue(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).stringValue(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
                }
                return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).stringValue(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + this.m_right.toString(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
            }
            if (this.m_right == null) {
                return "(" + this.m_left.toString(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).stringValue(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
            }
            return "(" + this.m_left.toString(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + this.m_right.toString(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
        }

        public String toString2(int attIndex) {
            DecimalFormat myFormatter = new DecimalFormat("#.#####");
            if (this.m_left == null) {
                if (this.m_right == null) {
                    return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).value(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).value(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
                }
                return "(" + HierarchicalClusterer.this.m_instances.instance(this.m_iLeftInstance).value(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + this.m_right.toString2(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
            }
            if (this.m_right == null) {
                return "(" + this.m_left.toString2(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + HierarchicalClusterer.this.m_instances.instance(this.m_iRightInstance).value(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
            }
            return "(" + this.m_left.toString2(attIndex) + ":" + myFormatter.format(this.m_fLeftLength) + "," + this.m_right.toString2(attIndex) + ":" + myFormatter.format(this.m_fRightLength) + ")";
        }

        void setHeight(double fHeight1, double fHeight2) {
            this.m_fHeight = fHeight1;
            this.m_fLeftLength = this.m_left == null ? fHeight1 : fHeight1 - this.m_left.m_fHeight;
            this.m_fRightLength = this.m_right == null ? fHeight2 : fHeight2 - this.m_right.m_fHeight;
        }

        void setLength(double fLength1, double fLength2) {
            this.m_fLeftLength = fLength1;
            this.m_fRightLength = fLength2;
            this.m_fHeight = fLength1;
            if (this.m_left != null) {
                this.m_fHeight += this.m_left.m_fHeight;
            }
        }
    }

    class Tuple {
        double m_fDist;
        int m_iCluster1;
        int m_iCluster2;
        int m_nClusterSize1;
        int m_nClusterSize2;

        public Tuple(double d, int i, int j, int nSize1, int nSize2) {
            this.m_fDist = d;
            this.m_iCluster1 = i;
            this.m_iCluster2 = j;
            this.m_nClusterSize1 = nSize1;
            this.m_nClusterSize2 = nSize2;
        }
    }

    class TupleComparator
    implements Comparator<Tuple> {
        TupleComparator() {
        }

        @Override
        public int compare(Tuple o1, Tuple o2) {
            if (o1.m_fDist < o2.m_fDist) {
                return -1;
            }
            if (o1.m_fDist == o2.m_fDist) {
                return 0;
            }
            return 1;
        }
    }
}

