/*
 * Decompiled with CFR 0.152.
 */
package dmLab.classifier.sliq;

import dmLab.classifier.sliq.AttributeList;
import dmLab.classifier.sliq.ClassList;

final class NominalHistogram {
    private int[][] left;
    private int[][] right;
    private int[] leftClassProxiesSummary;
    private int[] leftAttrProxiesSummary;
    private int[] rightClassProxiesSummary;
    private int[] rightAttrProxiesSummary;
    private int classProxiesNumber;
    private int attrProxiesNumber;

    public NominalHistogram(ClassList classList, AttributeList attributeList) {
        this.attrProxiesNumber = attributeList.getProxiesNumber();
        this.classProxiesNumber = classList.getProxiesNumber();
        this.left = new int[this.attrProxiesNumber][this.classProxiesNumber];
        this.right = new int[this.attrProxiesNumber][this.classProxiesNumber];
        this.leftClassProxiesSummary = new int[this.classProxiesNumber];
        this.leftAttrProxiesSummary = new int[this.attrProxiesNumber];
        this.rightClassProxiesSummary = new int[this.classProxiesNumber];
        this.rightAttrProxiesSummary = new int[this.attrProxiesNumber];
        int i = 0;
        while (i < this.attrProxiesNumber) {
            this.leftAttrProxiesSummary[i] = 0;
            this.rightAttrProxiesSummary[i] = 0;
            int j = 0;
            while (j < this.classProxiesNumber) {
                this.left[i][j] = 0;
                this.right[i][j] = 0;
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < this.classProxiesNumber) {
            this.leftClassProxiesSummary[j] = 0;
            this.rightClassProxiesSummary[j] = 0;
            ++j;
        }
    }

    public final void updateToLeft(int attrProxyIndex) {
        int classProxyIndex = 0;
        while (classProxyIndex < this.classProxiesNumber) {
            this.left[attrProxyIndex][classProxyIndex] = this.right[attrProxyIndex][classProxyIndex];
            int n = classProxyIndex;
            this.leftClassProxiesSummary[n] = this.leftClassProxiesSummary[n] + this.right[attrProxyIndex][classProxyIndex];
            int n2 = classProxyIndex;
            this.rightClassProxiesSummary[n2] = this.rightClassProxiesSummary[n2] - this.right[attrProxyIndex][classProxyIndex];
            this.right[attrProxyIndex][classProxyIndex] = 0;
            ++classProxyIndex;
        }
        this.leftAttrProxiesSummary[attrProxyIndex] = this.rightAttrProxiesSummary[attrProxyIndex];
        this.rightAttrProxiesSummary[var1_1] = 0;
    }

    public final void allToRight() {
        int attrProxyIndex = 0;
        while (attrProxyIndex < this.attrProxiesNumber) {
            int classProxyIndex = 0;
            while (classProxyIndex < this.classProxiesNumber) {
                int[] nArray = this.right[attrProxyIndex];
                int n = classProxyIndex;
                nArray[n] = nArray[n] + this.left[attrProxyIndex][classProxyIndex];
                int n2 = classProxyIndex;
                this.rightClassProxiesSummary[n2] = this.rightClassProxiesSummary[n2] + this.left[attrProxyIndex][classProxyIndex];
                int n3 = classProxyIndex;
                this.leftClassProxiesSummary[n3] = this.leftClassProxiesSummary[n3] - this.left[attrProxyIndex][classProxyIndex];
                this.left[attrProxyIndex][classProxyIndex] = 0;
                ++classProxyIndex;
            }
            int n = attrProxyIndex;
            this.rightAttrProxiesSummary[n] = this.rightAttrProxiesSummary[n] + this.leftAttrProxiesSummary[attrProxyIndex];
            this.leftAttrProxiesSummary[attrProxyIndex] = 0;
            ++attrProxyIndex;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void incRight(int attrProxyIndex, int classProxyIndex) {
        void var2_2;
        void var1_1;
        int n = attrProxyIndex;
        this.rightAttrProxiesSummary[n] = this.rightAttrProxiesSummary[n] + 1;
        int n2 = classProxyIndex;
        this.rightClassProxiesSummary[n2] = this.rightClassProxiesSummary[n2] + 1;
        int[] nArray = this.right[var1_1];
        void v3 = var2_2;
        nArray[v3] = nArray[v3] + 1;
    }

    public final int[] getHistogramArray(boolean child) {
        if (child) {
            return this.leftClassProxiesSummary;
        }
        return this.rightClassProxiesSummary;
    }

    public final int[] getAttrProxiesSummaryArray(boolean child) {
        return this.rightAttrProxiesSummary;
    }

    public final int getAttrProxiesNumber() {
        return this.attrProxiesNumber;
    }
}

