/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RelationalLocator;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.StringLocator;
import weka.core.Tag;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.UnsupervisedFilter;

public class MultiInstanceToPropositional
extends Filter
implements OptionHandler,
UnsupervisedFilter,
MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = -4102847628883002530L;
    protected int m_NumBags;
    protected StringLocator m_BagStringAtts = null;
    protected RelationalLocator m_BagRelAtts = null;
    protected int m_NumInstances;
    public static final int WEIGHTMETHOD_ORIGINAL = 0;
    public static final int WEIGHTMETHOD_1 = 1;
    public static final int WEIGHTMETHOD_INVERSE1 = 2;
    public static final int WEIGHTMETHOD_INVERSE2 = 3;
    public static final Tag[] TAGS_WEIGHTMETHOD = new Tag[]{new Tag(0, "keep the weight to be the same as the original value"), new Tag(1, "1.0"), new Tag(2, "1.0 / Total # of prop. instance in the corresp. bag"), new Tag(3, "Total # of prop. instance / (Total # of bags * Total # of prop. instance in the corresp. bag)")};
    protected int m_WeightMethod = 3;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe type of weight setting for each prop. instance:\n\t0.weight = original single bag weight /Total number of\n\tprop. instance in the corresponding bag;\n\t1.weight = 1.0;\n\t2.weight = 1.0/Total number of prop. instance in the \n\t\tcorresponding bag; \n\t3. weight = Total number of prop. instance / (Total number \n\t\tof bags * Total number of prop. instance in the \n\t\tcorresponding bag). \n\t(default:0)", "A", 1, "-A <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String weightString = Utils.getOption('A', options);
        if (weightString.length() != 0) {
            this.setWeightMethod(new SelectedTag(Integer.parseInt(weightString), TAGS_WEIGHTMETHOD));
        } else {
            this.setWeightMethod(new SelectedTag(3, TAGS_WEIGHTMETHOD));
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-A");
        result.add("" + this.m_WeightMethod);
        return result.toArray(new String[result.size()]);
    }

    public String weightMethodTipText() {
        return "The method used for weighting the instances.";
    }

    public void setWeightMethod(SelectedTag method) {
        if (method.getTags() == TAGS_WEIGHTMETHOD) {
            this.m_WeightMethod = method.getSelectedTag().getID();
        }
    }

    public SelectedTag getWeightMethod() {
        return new SelectedTag(this.m_WeightMethod, TAGS_WEIGHTMETHOD);
    }

    public String globalInfo() {
        return "Converts the multi-instance dataset into single instance dataset so that the Nominalize, Standardize and other type of filters or transformation  can be applied to these data for the further preprocessing.\nNote: the first attribute of the converted dataset is a nominal attribute and refers to the bagId.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.disableAllAttributes();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    @Override
    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enableAllAttributes();
        result.disable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        if (instanceInfo.attribute(1).type() != 4) {
            throw new Exception("Can only handle relational-valued attribute!");
        }
        super.setInputFormat(instanceInfo);
        this.m_NumBags = instanceInfo.numInstances();
        this.m_NumInstances = 0;
        int i = 0;
        while (i < this.m_NumBags) {
            this.m_NumInstances = instanceInfo.instance(i).relationalValue(1) == null ? ++this.m_NumInstances : (this.m_NumInstances += instanceInfo.instance(i).relationalValue(1).numInstances());
            ++i;
        }
        Attribute classAttribute = (Attribute)instanceInfo.classAttribute().copy();
        Attribute bagIndex = (Attribute)instanceInfo.attribute(0).copy();
        Instances newData = instanceInfo.attribute(1).relation().stringFreeStructure();
        newData.insertAttributeAt(bagIndex, 0);
        newData.insertAttributeAt(classAttribute, newData.numAttributes());
        newData.setClassIndex(newData.numAttributes() - 1);
        super.setOutputFormat(newData.stringFreeStructure());
        this.m_BagStringAtts = new StringLocator(instanceInfo.attribute(1).relation().stringFreeStructure());
        this.m_BagRelAtts = new RelationalLocator(instanceInfo.attribute(1).relation().stringFreeStructure());
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        this.convertInstance(instance);
        return true;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        Instances input = this.getInputFormat();
        int i = 0;
        while (i < input.numInstances()) {
            this.convertInstance(input.instance(i));
            ++i;
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance bag) {
        Instances data = bag.relationalValue(1);
        int bagSize = 1;
        if (data != null) {
            bagSize = data.numInstances();
        }
        double bagIndex = bag.value(0);
        double classValue = bag.classValue();
        double weight = 0.0;
        weight = this.m_WeightMethod == 1 ? 1.0 : (this.m_WeightMethod == 2 ? 1.0 / (double)bagSize : (this.m_WeightMethod == 3 ? (double)this.m_NumInstances / (double)(this.m_NumBags * bagSize) : bag.weight() / (double)bagSize));
        Instances outputFormat = this.getOutputFormat().stringFreeStructure();
        int i = 0;
        while (i < bagSize) {
            Instance newInst = new Instance(outputFormat.numAttributes());
            newInst.setDataset(outputFormat);
            newInst.setValue(0, bagIndex);
            if (!bag.classIsMissing()) {
                newInst.setClassValue(classValue);
            }
            int j = 1;
            while (j < outputFormat.numAttributes() - 1) {
                if (data == null) {
                    newInst.setMissing(j);
                } else {
                    newInst.setValue(j, data.instance(i).value(j - 1));
                }
                ++j;
            }
            newInst.setWeight(weight);
            StringLocator.copyStringValues(newInst, false, data, this.m_BagStringAtts, outputFormat, this.m_OutputStringAtts);
            RelationalLocator.copyRelationalValues(newInst, false, data, this.m_BagRelAtts, outputFormat, this.m_OutputRelAtts);
            this.push(newInst);
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9141 $");
    }

    public static void main(String[] args) {
        MultiInstanceToPropositional.runFilter(new MultiInstanceToPropositional(), args);
    }
}

