/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat;

import cern.jet.math.Constants;
import cern.jet.math.Polynomial;

public class Gamma
extends Constants {
    protected Gamma() {
    }

    public static double beta(double d, double d2) throws ArithmeticException {
        double d3 = d + d2;
        if ((d3 = Gamma.gamma(d3)) == 0.0) {
            return 1.0;
        }
        if (d > d2) {
            d3 = Gamma.gamma(d) / d3;
            d3 *= Gamma.gamma(d2);
        } else {
            d3 = Gamma.gamma(d2) / d3;
            d3 *= Gamma.gamma(d);
        }
        return d3;
    }

    public static double gamma(double d) throws ArithmeticException {
        double[] dArray = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] dArray2 = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double d2 = Math.abs(d);
        if (d2 > 33.0) {
            if (d < 0.0) {
                double d3 = Math.floor(d2);
                if (d3 == d2) {
                    throw new ArithmeticException("gamma: overflow");
                }
                int n = (int)d3;
                double d4 = d2 - d3;
                if (d4 > 0.5) {
                    d4 = d2 - (d3 += 1.0);
                }
                if ((d4 = d2 * Math.sin(Math.PI * d4)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                d4 = Math.abs(d4);
                d4 = Math.PI / (d4 * Gamma.stirlingFormula(d2));
                return -d4;
            }
            return Gamma.stirlingFormula(d);
        }
        double d5 = 1.0;
        while (d >= 3.0) {
            d5 *= (d -= 1.0);
        }
        while (d < 0.0) {
            if (d == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d > -1.0E-9) {
                return d5 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d5 /= d;
            d += 1.0;
        }
        while (d < 2.0) {
            if (d == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (d < 1.0E-9) {
                return d5 / ((1.0 + 0.5772156649015329 * d) * d);
            }
            d5 /= d;
            d += 1.0;
        }
        if (d == 2.0 || d == 3.0) {
            return d5;
        }
        double d6 = Polynomial.polevl(d -= 2.0, dArray, 6);
        d2 = Polynomial.polevl(d, dArray2, 7);
        return d5 * d6 / d2;
    }

    public static double incompleteBeta(double d, double d2, double d3) throws ArithmeticException {
        double d4;
        double d5;
        double d6;
        double d7;
        if (d <= 0.0 || d2 <= 0.0) {
            throw new ArithmeticException("ibeta: Domain error!");
        }
        if (d3 <= 0.0 || d3 >= 1.0) {
            if (d3 == 0.0) {
                return 0.0;
            }
            if (d3 == 1.0) {
                return 1.0;
            }
            throw new ArithmeticException("ibeta: Domain error!");
        }
        boolean bl = false;
        if (d2 * d3 <= 1.0 && d3 <= 0.95) {
            double d8 = Gamma.powerSeries(d, d2, d3);
            return d8;
        }
        double d9 = 1.0 - d3;
        if (d3 > d / (d + d2)) {
            bl = true;
            d7 = d2;
            d6 = d;
            d5 = d3;
            d4 = d9;
        } else {
            d7 = d;
            d6 = d2;
            d5 = d9;
            d4 = d3;
        }
        if (bl && d6 * d4 <= 1.0 && d4 <= 0.95) {
            double d10 = Gamma.powerSeries(d7, d6, d4);
            d10 = d10 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d10;
            return d10;
        }
        double d11 = d4 * (d7 + d6 - 2.0) - (d7 - 1.0);
        d9 = d11 < 0.0 ? Gamma.incompleteBetaFraction1(d7, d6, d4) : Gamma.incompleteBetaFraction2(d7, d6, d4) / d5;
        d11 = d7 * Math.log(d4);
        double d12 = d6 * Math.log(d5);
        if (d7 + d6 < 171.6243769563027 && Math.abs(d11) < 709.782712893384 && Math.abs(d12) < 709.782712893384) {
            d12 = Math.pow(d5, d6);
            d12 *= Math.pow(d4, d7);
            d12 /= d7;
            d12 *= d9;
            d12 *= Gamma.gamma(d7 + d6) / (Gamma.gamma(d7) * Gamma.gamma(d6));
            if (bl) {
                d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
            }
            return d12;
        }
        d11 += d12 + Gamma.logGamma(d7 + d6) - Gamma.logGamma(d7) - Gamma.logGamma(d6);
        d12 = (d11 += Math.log(d9 / d7)) < -745.1332191019412 ? 0.0 : Math.exp(d11);
        if (bl) {
            d12 = d12 <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - d12;
        }
        return d12;
    }

    static double incompleteBetaFraction1(double d, double d2, double d3) throws ArithmeticException {
        double d4 = d;
        double d5 = d + d2;
        double d6 = d;
        double d7 = d + 1.0;
        double d8 = 1.0;
        double d9 = d2 - 1.0;
        double d10 = d7;
        double d11 = d + 2.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = 1.0;
        double d17 = 1.0;
        int n = 0;
        double d18 = 3.330669E-16f;
        do {
            double d19;
            double d20 = -(d3 * d4 * d5) / (d6 * d7);
            double d21 = d14 + d12 * d20;
            double d22 = d15 + d13 * d20;
            d12 = d14;
            d14 = d21;
            d13 = d15;
            d15 = d22;
            d20 = d3 * d8 * d9 / (d10 * d11);
            d21 = d14 + d12 * d20;
            d22 = d15 + d13 * d20;
            d12 = d14;
            d14 = d21;
            d13 = d15;
            d15 = d22;
            if (d22 != 0.0) {
                d17 = d21 / d22;
            }
            if (d17 != 0.0) {
                d19 = Math.abs((d16 - d17) / d17);
                d16 = d17;
            } else {
                d19 = 1.0;
            }
            if (d19 < d18) {
                return d16;
            }
            d4 += 1.0;
            d5 += 1.0;
            d6 += 2.0;
            d7 += 2.0;
            d8 += 1.0;
            d9 -= 1.0;
            d10 += 2.0;
            d11 += 2.0;
            if (Math.abs(d22) + Math.abs(d21) > 4.503599627370496E15) {
                d12 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d22) < 2.220446049250313E-16) && !(Math.abs(d21) < 2.220446049250313E-16)) continue;
            d12 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
        } while (++n < 300);
        return d16;
    }

    static double incompleteBetaFraction2(double d, double d2, double d3) throws ArithmeticException {
        double d4 = d;
        double d5 = d2 - 1.0;
        double d6 = d;
        double d7 = d + 1.0;
        double d8 = 1.0;
        double d9 = d + d2;
        double d10 = d + 1.0;
        double d11 = d + 2.0;
        double d12 = 0.0;
        double d13 = 1.0;
        double d14 = 1.0;
        double d15 = 1.0;
        double d16 = d3 / (1.0 - d3);
        double d17 = 1.0;
        double d18 = 1.0;
        int n = 0;
        double d19 = 3.330669E-16f;
        do {
            double d20;
            double d21 = -(d16 * d4 * d5) / (d6 * d7);
            double d22 = d14 + d12 * d21;
            double d23 = d15 + d13 * d21;
            d12 = d14;
            d14 = d22;
            d13 = d15;
            d15 = d23;
            d21 = d16 * d8 * d9 / (d10 * d11);
            d22 = d14 + d12 * d21;
            d23 = d15 + d13 * d21;
            d12 = d14;
            d14 = d22;
            d13 = d15;
            d15 = d23;
            if (d23 != 0.0) {
                d18 = d22 / d23;
            }
            if (d18 != 0.0) {
                d20 = Math.abs((d17 - d18) / d18);
                d17 = d18;
            } else {
                d20 = 1.0;
            }
            if (d20 < d19) {
                return d17;
            }
            d4 += 1.0;
            d5 -= 1.0;
            d6 += 2.0;
            d7 += 2.0;
            d8 += 1.0;
            d9 += 1.0;
            d10 += 2.0;
            d11 += 2.0;
            if (Math.abs(d23) + Math.abs(d22) > 4.503599627370496E15) {
                d12 *= 2.220446049250313E-16;
                d14 *= 2.220446049250313E-16;
                d13 *= 2.220446049250313E-16;
                d15 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(d23) < 2.220446049250313E-16) && !(Math.abs(d22) < 2.220446049250313E-16)) continue;
            d12 *= 4.503599627370496E15;
            d14 *= 4.503599627370496E15;
            d13 *= 4.503599627370496E15;
            d15 *= 4.503599627370496E15;
        } while (++n < 300);
        return d17;
    }

    public static double incompleteGamma(double d, double d2) throws ArithmeticException {
        if (d2 <= 0.0 || d <= 0.0) {
            return 0.0;
        }
        if (d2 > 1.0 && d2 > d) {
            return 1.0 - Gamma.incompleteGammaComplement(d, d2);
        }
        double d3 = d * Math.log(d2) - d2 - Gamma.logGamma(d);
        if (d3 < -709.782712893384) {
            return 0.0;
        }
        d3 = Math.exp(d3);
        double d4 = d;
        double d5 = 1.0;
        double d6 = 1.0;
        while ((d5 *= d2 / (d4 += 1.0)) / (d6 += d5) > (double)1.110223E-16f) {
        }
        return d6 * d3 / d;
    }

    public static double incompleteGammaComplement(double d, double d2) throws ArithmeticException {
        double d3;
        if (d2 <= 0.0 || d <= 0.0) {
            return 1.0;
        }
        if (d2 < 1.0 || d2 < d) {
            return 1.0 - Gamma.incompleteGamma(d, d2);
        }
        double d4 = d * Math.log(d2) - d2 - Gamma.logGamma(d);
        if (d4 < -709.782712893384) {
            return 0.0;
        }
        d4 = Math.exp(d4);
        double d5 = 1.0 - d;
        double d6 = d2 + d5 + 1.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = d2;
        double d10 = d2 + 1.0;
        double d11 = d6 * d2;
        double d12 = d10 / d11;
        do {
            double d13 = (d5 += 1.0) * (d7 += 1.0);
            double d14 = d10 * (d6 += 2.0) - d8 * d13;
            double d15 = d11 * d6 - d9 * d13;
            if (d15 != 0.0) {
                double d16 = d14 / d15;
                d3 = Math.abs((d12 - d16) / d16);
                d12 = d16;
            } else {
                d3 = 1.0;
            }
            d8 = d10;
            d10 = d14;
            d9 = d11;
            d11 = d15;
            if (!(Math.abs(d14) > 4.503599627370496E15)) continue;
            d8 *= 2.220446049250313E-16;
            d10 *= 2.220446049250313E-16;
            d9 *= 2.220446049250313E-16;
            d11 *= 2.220446049250313E-16;
        } while (d3 > (double)1.110223E-16f);
        return d12 * d4;
    }

    public static double logGamma(double d) throws ArithmeticException {
        double[] dArray = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] dArray2 = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] dArray3 = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (d < -34.0) {
            double d2 = -d;
            double d3 = Gamma.logGamma(d2);
            double d4 = Math.floor(d2);
            if (d4 == d2) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double d5 = d2 - d4;
            if (d5 > 0.5) {
                d5 = (d4 += 1.0) - d2;
            }
            if ((d5 = d2 * Math.sin(Math.PI * d5)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            d5 = 1.1447298858494002 - Math.log(d5) - d3;
            return d5;
        }
        if (d < 13.0) {
            double d6 = 1.0;
            while (d >= 3.0) {
                d6 *= (d -= 1.0);
            }
            while (d < 2.0) {
                if (d == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                d6 /= d;
                d += 1.0;
            }
            if (d6 < 0.0) {
                d6 = -d6;
            }
            if (d == 2.0) {
                return Math.log(d6);
            }
            double d7 = (d -= 2.0) * Polynomial.polevl(d, dArray2, 5) / Polynomial.p1evl(d, dArray3, 6);
            return Math.log(d6) + d7;
        }
        if (d > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double d8 = (d - 0.5) * Math.log(d) - d + 0.9189385332046728;
        if (d > 1.0E8) {
            return d8;
        }
        double d9 = 1.0 / (d * d);
        d8 = d >= 1000.0 ? (d8 += ((7.936507936507937E-4 * d9 - 0.002777777777777778) * d9 + 0.08333333333333333) / d) : (d8 += Polynomial.polevl(d9, dArray, 4) / d);
        return d8;
    }

    static double powerSeries(double d, double d2, double d3) throws ArithmeticException {
        double d4;
        double d5 = 1.0 / d;
        double d6 = (1.0 - d2) * d3;
        double d7 = d4 = d6 / (d + 1.0);
        double d8 = d6;
        double d9 = 2.0;
        double d10 = 0.0;
        double d11 = (double)1.110223E-16f * d5;
        while (Math.abs(d4) > d11) {
            d6 = (d9 - d2) * d3 / d9;
            d4 = (d8 *= d6) / (d + d9);
            d10 += d4;
            d9 += 1.0;
        }
        d10 += d7;
        d10 += d5;
        d6 = d * Math.log(d3);
        if (d + d2 < 171.6243769563027 && Math.abs(d6) < 709.782712893384) {
            d8 = Gamma.gamma(d + d2) / (Gamma.gamma(d) * Gamma.gamma(d2));
            d10 = d10 * d8 * Math.pow(d3, d);
        } else {
            d8 = Gamma.logGamma(d + d2) - Gamma.logGamma(d) - Gamma.logGamma(d2) + d6 + Math.log(d10);
            d10 = d8 < -745.1332191019412 ? 0.0 : Math.exp(d8);
        }
        return d10;
    }

    static double stirlingFormula(double d) throws ArithmeticException {
        double[] dArray = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double d2 = 143.01608;
        double d3 = 1.0 / d;
        double d4 = Math.exp(d);
        d3 = 1.0 + d3 * Polynomial.polevl(d3, dArray, 4);
        if (d > d2) {
            double d5 = Math.pow(d, 0.5 * d - 0.25);
            d4 = d5 * (d5 / d4);
        } else {
            d4 = Math.pow(d, d - 0.5) / d4;
        }
        d4 = 2.5066282746310007 * d4 * d3;
        return d4;
    }
}

