/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import cern.jet.stat.Probability;
import dmLab.array.Array;
import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.array.saver.Array2ADH;
import dmLab.array.saver.Array2CSV;
import dmLab.array.saver.Array2String;
import dmLab.classifier.Classifier;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.mcfsEngine.MCFSFinalCV;
import dmLab.mcfs.mcfsEngine.framework.MCFSClassic;
import dmLab.mcfs.mcfsEngine.framework.MCFSFramework;
import dmLab.mcfs.mcfsEngine.framework.MCFSPermutation;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipOutputStream;

public final class MCFSExperiment
implements Runnable {
    private MCFSFramework mcfs;
    private MCFSParams myParams;
    private Random random;

    /*
     * WARNING - void declaration
     */
    public MCFSExperiment(MCFSParams mcfsParams) {
        void var1_1;
        this.random = new Random(mcfsParams.seed);
        this.myParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        if (this.myParams.mode == 2) {
            void var3_3;
            void var1_1;
            void var2_2;
            MCFSParams tmpParams = this.myParams.clone();
            this.myParams.clone().buildID = false;
            tmpParams.finalRuleset = false;
            tmpParams.finalCV = false;
            tmpParams.saveResutFiles = false;
            tmpParams.cutoffMethod = "contrast";
            System.out.println("****************************************************");
            System.out.println("*** Running stage I - initial MCFS-ID filtering  ***");
            FArray tmpArray = this.start(tmpParams);
            tmpParams = this.myParams.clone();
            String contrastFileName = DiscFunctions.dropFileExtension(new File(tmpParams.inputFileName));
            DiscFunctions.saveString(String.valueOf(MCFSParams.TMP_PATH) + contrastFileName + ".adx", var2_2.toString());
            tmpParams.inputFilesPATH = MCFSParams.TMP_PATH;
            tmpParams.inputFileName = String.valueOf(contrastFileName) + ".adx";
            System.out.println("***************************************************");
            System.out.println("*** Running stage II - final MCFS-ID filtering  ***");
            this.start((MCFSParams)var1_1);
            DiscFunctions.deleteFile(String.valueOf(MCFSParams.TMP_PATH) + (String)var3_3 + ".adx");
            return;
        }
        this.start(this.myParams);
    }

    /*
     * WARNING - void declaration
     */
    private FArray start(MCFSParams mcfsParams) {
        void var1_1;
        void var2_2;
        Object object;
        long start = System.currentTimeMillis();
        if (!mcfsParams.check(null)) {
            return null;
        }
        DataFrame permutationRIValues = null;
        ArrayList<Float> maxPermutationRI = new ArrayList<Float>();
        ArrayList<Float> maxPermutationID = new ArrayList<Float>();
        ArrayList<String> permPrefix = new ArrayList<String>();
        if (mcfsParams.cutoffMethod.equalsIgnoreCase("permutations")) {
            int i = 0;
            while (i < mcfsParams.cutoffPermutations) {
                System.out.println("***************************************************");
                System.out.println("*** MCFS-ID Cutoff Permutation Experiment #" + (i + 1) + "/" + mcfsParams.cutoffPermutations + " ***");
                System.out.println("***************************************************");
                this.mcfs = new MCFSPermutation(this.random);
                this.mcfs.chartTitle = "MCFS-ID Progress - Permutation Experiment #" + (i + 1);
                ((MCFSPermutation)this.mcfs).permPrefix = String.valueOf(((MCFSPermutation)this.mcfs).permPrefix) + (i + 1) + "_";
                permPrefix.add(((MCFSPermutation)this.mcfs).permPrefix);
                mcfsParams.saveResutFiles = false;
                if (!this.mcfs.run(mcfsParams)) {
                    return null;
                }
                AttributesRI imp = this.mcfs.globalStats.getAttrImportances()[0];
                if (permutationRIValues == null) {
                    permutationRIValues = MCFSExperiment.createPermutationResult(this.mcfs.mcfsArrays.sourceArray, mcfsParams);
                }
                permutationRIValues.setColumn(i + 1, imp.getImportanceValues(imp.mainMeasureIdx));
                float[] minMax = imp.getMinMaxImportances(imp.mainMeasureIdx);
                maxPermutationRI.add(Float.valueOf(minMax[1]));
                if (this.mcfs.globalStats.getAttrConnections() != null) {
                    maxPermutationID.add(Float.valueOf(this.mcfs.globalStats.getAttrConnections().getMaxID()));
                }
                ++i;
            }
        }
        String experimentName = mcfsParams.getExperimentName();
        System.out.println("**************************");
        System.out.println("*** MCFS-ID Experiment ***");
        System.out.println("**************************");
        this.mcfs = new MCFSClassic(this.random);
        this.mcfs.chartTitle = "MCFS-ID Progress - Raw Data";
        mcfsParams.saveResutFiles = true;
        if (!this.mcfs.run(mcfsParams)) {
            return null;
        }
        AttributesRI importancesClassic = this.mcfs.globalStats.getAttrImportances()[0];
        if (permutationRIValues != null) {
            int mainMeasureIndex = importancesClassic.mainMeasureIdx;
            DataFrame p_values = MCFSExperiment.calc_pValues$662b6a5a(permutationRIValues, importancesClassic.getImportanceValues(mainMeasureIndex));
            permutationRIValues.cbind(p_values);
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_PERMUTATIONS, permutationRIValues.toString());
            System.out.println("*** Calculation of cutoff RI ***");
            float[] minMaxRI = importancesClassic.getMinMaxImportances(mainMeasureIndex);
            System.out.println("Max RI (raw data) = " + minMaxRI[1]);
            System.out.println("Max RI (after permutations) = " + Arrays.toString(maxPermutationRI.toArray()));
            double cutoffRI = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationRI.toArray()));
            Ranking topRanking = importancesClassic.getTopRanking(mainMeasureIndex, (float)cutoffRI);
            int topRankingSize2 = 0;
            if (topRanking != null) {
                topRankingSize2 = topRanking.size();
            }
            System.out.println("Minimal important (based on permutations) RI = " + DiscFunctions.formatFloat(cutoffRI, 7));
            System.out.println("Top important (based on permutations) attributes number = " + topRankingSize2);
            double cutoffID = Double.NaN;
            if (!maxPermutationID.isEmpty()) {
                System.out.println("*** Calculation of cutoff ID ***");
                cutoffID = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationID.toArray()));
                System.out.println("Minimal important (based on permutations) ID = " + DiscFunctions.formatFloat(cutoffID, 7));
            }
            DataFrame cutoff = this.mcfs.globalStats.getCutoff().getCutoffTable();
            cutoff = cutoff.excludeRows(new int[]{cutoff.rows() - 1});
            DataFrame cutoffRow = new DataFrame(1, cutoff);
            int lastRowIdx = cutoffRow.rows() - 1;
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("method"), "permutations");
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minRI"), cutoffRI);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("size"), topRankingSize2);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minID"), cutoffID);
            cutoff.rbind(cutoffRow);
            this.mcfs.globalStats.getCutoff().setCutoffTable(cutoff);
            this.mcfs.globalStats.getCutoff().addMeanValue(importancesClassic);
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, this.mcfs.globalStats.getCutoff().toString());
            MCFSExperiment.removePermResultTempFiles(permPrefix, mcfsParams);
            String topRankingMethod = this.mcfs.globalStats.getCutoff().getMethod(mcfsParams.cutoffMethod);
            topRankingSize2 = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(topRankingMethod);
            object = importancesClassic.getTopRankingSize(mainMeasureIndex, topRankingSize2);
            System.out.println("*** Final top important (based on " + topRankingMethod + ") attributes = " + ((Ranking)object).size());
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, ((Ranking)object).toString());
        }
        if (mcfsParams.finalCV) {
            int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 4);
            MCFSFinalCV simpleCV = this.mcfs.mcfsArrays.sourceArray.isTargetNominal() ? new MCFSFinalCV(new int[]{Classifier.J48, Classifier.NB, Classifier.SVM, Classifier.KNN, Classifier.LOGISTIC, Classifier.RIPPER}, this.random) : new MCFSFinalCV(new int[]{Classifier.M5}, this.random);
            int[] cutoffValues = MCFSExperiment.getCutoffValues(new int[]{topRankingSize});
            System.out.println("");
            System.out.println("*** Running CV experiment on top " + Arrays.toString(cutoffValues) + " attributes ***");
            DataFrame res = simpleCV.run(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], cutoffValues, mcfsParams.foldsCV, mcfsParams.finalCVSetSize, mcfsParams.finalCVRepetitions);
            if (mcfsParams.saveResutFiles) {
                DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_CV_RESULT, res.toString());
            }
        }
        int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 2);
        FArray topRankingArray = (FArray)DiscFunctions.selectColumns(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], topRankingSize);
        if (mcfsParams.finalRuleset && this.mcfs.mcfsArrays.sourceArray.isTargetNominal()) {
            System.out.println("");
            System.out.println("*** Building RIPPER ruleset on top " + topRankingSize + " attributes ***");
            ClassificationBody classification = new ClassificationBody(this.random);
            classification.setParameters(new ClassificationParams());
            classification.classParams.verbose = false;
            classification.classParams.saveClassifier = false;
            classification.classParams.savePredictionResult = false;
            classification.classParams.repetitions = 1;
            classification.classParams.model = Classifier.RIPPER;
            classification.initClassifier();
            classification.runTrainTest(topRankingArray, topRankingArray);
            String ripperResult = String.valueOf(classification.classifier.toString(false)) + "\n";
            classification.initClassifier();
            classification.classParams.folds = mcfsParams.foldsCV;
            classification.classParams.repetitions = mcfsParams.finalCVRepetitions;
            classification.runCV(topRankingArray);
            ripperResult = String.valueOf(ripperResult) + "RIPPER CV Result (10 folds repeated " + mcfsParams.finalCVRepetitions + " times)\n" + classification.predResult.toString();
            System.out.println(ripperResult);
            if (mcfsParams.saveResutFiles) {
                DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_RULESET, ripperResult);
            }
        }
        if (mcfsParams.saveResutFiles) {
            System.out.println("*** Saving filtered data ***");
            object = topRankingArray;
            Array2String topRankingSize2 = new Array2ADH();
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".adh", topRankingSize2.toString((Array)object));
            object = topRankingArray;
            topRankingSize2 = new Array2CSV();
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".csv", ((Array2CSV)topRankingSize2).toString((Array)object));
        }
        if (mcfsParams.saveResutFiles && mcfsParams.zipResult) {
            String[] files = MCFSParams.getAllResultFileName(experimentName);
            try {
                FileOutputStream fos = new FileOutputStream(String.valueOf(mcfsParams.resFilesPATH) + experimentName + ".zip");
                ZipOutputStream zos = new ZipOutputStream(fos);
                int i = 0;
                while (i < 12) {
                    DiscFunctions.addFileToZip(String.valueOf(mcfsParams.resFilesPATH) + files[i], zos);
                    ++i;
                }
                DiscFunctions.addFileToZip(String.valueOf(mcfsParams.resFilesPATH) + experimentName + ".run", zos);
                zos.close();
                fos.close();
                i = 0;
                while (i < 12) {
                    DiscFunctions.deleteFile(String.valueOf(mcfsParams.resFilesPATH) + files[i]);
                    ++i;
                }
                DiscFunctions.deleteFile(String.valueOf(mcfsParams.resFilesPATH) + experimentName + ".run");
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                iOException.printStackTrace();
            }
        }
        long l = System.currentTimeMillis();
        float experimentTime = (float)(l - var2_2) / 1000.0f;
        System.out.println("*** Calculations for input data: '" + DiscFunctions.dropFileExtension(new File(var1_1.inputFileName)) + "' are finished! Processing time: " + DiscFunctions.timeIntervalFormat(experimentTime) + " ***");
        return topRankingArray;
    }

    private static int removePermResultTempFiles(ArrayList<String> permPrefix, MCFSParams mcfsParams) {
        String experimentName = mcfsParams.getExperimentName();
        int i = 0;
        while (i < permPrefix.size()) {
            String string = String.valueOf(mcfsParams.resFilesPATH) + permPrefix.get(i) + experimentName + "__" + MCFSParams.FILESUFIX_RI;
            DiscFunctions.deleteFile(string);
            ++i;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame createPermutationResult(FArray inputArrray, MCFSParams mcfsParams) {
        void var3_4;
        FArray fArray;
        void var2_2;
        void var1_1;
        String[] colNames = new String[mcfsParams.cutoffPermutations + 1];
        short[] colTypes = new short[colNames.length];
        colNames[0] = "attribute";
        colTypes[0] = 0;
        int i22 = 1;
        while (i22 < colNames.length) {
            colNames[i22] = "perm_" + i22;
            colTypes[i22] = 1;
            ++i22;
        }
        FArray i22 = inputArrray;
        DataFrame permResult = new DataFrame(i22.attributes.length - 1, colNames.length);
        permResult.setColNames((String[])var1_1);
        permResult.setColTypes((short[])var2_2);
        permResult.setColumn(0, fArray.getColNames(false));
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static double getCutoff(double alpha, double[] values) {
        void var0_1;
        void var2_2;
        void var3_3;
        double pValue = DiscFunctions.andersonDarlingNormTest(values);
        System.out.println("Anderson-Darling normality test p-value = " + DiscFunctions.formatFloat((double)var3_3, 7));
        double[] confidence = DiscFunctions.getConfidenceInterval(alpha, (double[])var2_2);
        System.out.println("Confidence Interval: " + DiscFunctions.formatFloat(confidence[0], 7) + " ; " + DiscFunctions.formatFloat(confidence[1], 7));
        return (double)var0_1[1];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getCutoffValues(int[] cutoffValues) {
        int[] nArray;
        Integer[] integerArray;
        void var1_1;
        Arrays.sort(cutoffValues);
        HashSet<Integer> vset = new HashSet<Integer>();
        int i = 0;
        while (i <= 0) {
            vset.add(cutoffValues[0]);
            ++i;
        }
        vset.removeAll(Arrays.asList(0));
        Integer[] tmpArray = new Integer[1];
        tmpArray = vset.toArray(tmpArray);
        cutoffValues = ArrayUtils.Integer2int(tmpArray);
        Arrays.sort(cutoffValues);
        vset.add(Math.round((float)cutoffValues[0] * 0.75f));
        vset.add(Math.round((float)cutoffValues[0] * 0.5f));
        vset.add(Math.round((float)cutoffValues[0] * 0.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.5f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 2.0f));
        integerArray = (Integer[])var1_1.toArray(integerArray);
        cutoffValues = ArrayUtils.Integer2int(integerArray);
        Arrays.sort(cutoffValues);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame calc_pValues$662b6a5a(DataFrame permutationRIValues, float[] valuesRI) {
        void var2_2;
        void var1_1;
        DataFrame dataFrame;
        String[] colNames = permutationRIValues.getColNames();
        boolean[] colNamesMask = new boolean[colNames.length];
        int permNumber = 0;
        int i = 0;
        while (i < colNames.length) {
            if (colNames[i].startsWith("perm_")) {
                colNamesMask[i] = true;
                ++permNumber;
            } else {
                colNamesMask[i] = false;
            }
            ++i;
        }
        float[] mean = new float[permutationRIValues.rows()];
        float[] normality_p = new float[permutationRIValues.rows()];
        float[] ttest_p = new float[permutationRIValues.rows()];
        int i2 = 0;
        while (i2 < permutationRIValues.rows()) {
            Object[] row = permutationRIValues.getRow(i2);
            double[] permRI = new double[permNumber];
            int currPermIdx = 0;
            int j = 0;
            while (j < row.length) {
                if (colNamesMask[j]) {
                    permRI[currPermIdx++] = ((Float)row[j]).floatValue();
                }
                ++j;
            }
            mean[i2] = (float)MathUtils.mean(permRI);
            normality_p[i2] = (float)DiscFunctions.andersonDarlingNormTest(permRI);
            double d = valuesRI[i2];
            double[] dArray = permRI;
            double d2 = (MathUtils.mean(permRI) - d) / (MathUtils.stdev(dArray) / Math.sqrt(dArray.length));
            double d3 = 2.0 * Probability.studentT((double)(dArray.length - 1), (double)(-Math.abs(d2)));
            ttest_p[i2] = (float)d3;
            ++i2;
        }
        DataFrame p_values = new DataFrame(dataFrame.rows(), 4);
        p_values.setColNames(new String[]{"mean", "RI_norm", "normality_test_p", "t_test_p"});
        p_values.setColTypes(new short[]{1, 1, 1, 1});
        p_values.setColumn(0, mean);
        p_values.setColumn(1, (float[])var1_1);
        p_values.setColumn(2, (float[])var2_2);
        p_values.setColumn(3, ttest_p);
        return p_values;
    }
}

