/*
 * Decompiled with CFR 0.152.
 */
package dmLab.experiment.classification;

import dmLab.array.FArray;
import dmLab.classifier.Classifier;
import dmLab.experiment.ExperimentParams;
import java.util.Properties;

public final class ClassificationParams
extends ExperimentParams {
    public int model;
    public int repetitions;
    public double splitRatio;
    public int splitType;
    public int validationType;
    public int folds;
    public boolean saveClassifier;
    public boolean savePredictionResult;

    public ClassificationParams() {
        this.fileType = "run";
    }

    @Override
    public final boolean setDefault() {
        this.label = "experiment";
        this.inputFilesPATH = ".//data//";
        this.resFilesPATH = ".//results//";
        this.verbose = true;
        this.debug = false;
        this.inputFileName = "";
        this.testFileName = "";
        this.outputFileName = "";
        this.savePredictionResult = false;
        this.model = Classifier.label2int("j48");
        this.saveClassifier = true;
        this.validationType = 2;
        this.folds = 3;
        this.repetitions = 1;
        this.splitRatio = 0.66;
        this.splitType = 2;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var1_1;
        StringBuffer tmp = new StringBuffer();
        tmp.append(super.toString()).append('\n');
        tmp.append("### Classification Parameters ### \n");
        tmp.append("model=" + Classifier.int2label(this.model)).append('\n');
        tmp.append("saveClassifier=" + this.saveClassifier).append('\n');
        tmp.append("savePredictionResult=" + this.savePredictionResult).append('\n');
        if (this.validationType == 1) {
            tmp.append("validationType=split\n");
        } else if (this.validationType == 2) {
            tmp.append("validationType=cv\n");
        } else if (this.validationType == 3) {
            tmp.append("validationType=testSet\n");
        }
        tmp.append("repetitions=" + this.repetitions).append('\n');
        tmp.append("splitRatio=" + this.splitRatio).append('\n');
        if (this.splitType == 1) {
            tmp.append("splitType=random\n");
        }
        if (this.splitType == 2) {
            tmp.append("splitType=uniform\n");
        }
        tmp.append("folds=" + this.folds).append('\n');
        return var1_1.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final boolean update(Properties properties) {
        void var1_1;
        if (!super.update(properties)) {
            return false;
        }
        this.model = Classifier.label2int(properties.getProperty("model", "j48"));
        this.repetitions = Integer.valueOf(properties.getProperty("repetitions", "1"));
        this.splitRatio = Double.valueOf(properties.getProperty("splitRatio", "0.66"));
        if (properties.getProperty("splitType", "uniform").equalsIgnoreCase("random")) {
            this.splitType = 1;
        } else if (properties.getProperty("splitType", "uniform").equalsIgnoreCase("uniform")) {
            this.splitType = 2;
        }
        if (properties.getProperty("validationType", "cv").equalsIgnoreCase("split")) {
            this.validationType = 1;
        } else if (properties.getProperty("validationType", "cv").equalsIgnoreCase("cv")) {
            this.validationType = 2;
        } else if (properties.getProperty("validationType", "cv").equalsIgnoreCase("testSet")) {
            this.validationType = 3;
        }
        this.folds = Integer.valueOf(properties.getProperty("folds", "1"));
        this.saveClassifier = Boolean.valueOf(properties.getProperty("saveClassifier", "true"));
        this.savePredictionResult = Boolean.valueOf(var1_1.getProperty("savePredictionResult", "false"));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean check(FArray array) {
        if (!super.check(array)) {
            return false;
        }
        if (this.splitRatio <= 0.0 || this.splitRatio > 1.0) {
            System.err.println("Incorrect 'splitRatio' parameter");
            return false;
        }
        if (this.repetitions <= 0) {
            System.err.println("Incorrect 'repetitions' parameter");
            return false;
        }
        if (this.folds <= 0) {
            System.err.println("Incorrect 'folds' parameter");
            return false;
        }
        if (this.model < 0) {
            System.err.println("Incorrect 'classifier' parameter.");
            return false;
        }
        if (this.testFileName.length() == 0 && this.validationType == 3) {
            System.err.println("Parameter 'testFileName' is not defined.");
            return false;
        }
        Classifier c = Classifier.getClassifier(this.model);
        if (array != null) {
            void var2_2;
            void var1_1;
            if (!array.isTargetNominal() && c.isClassifier()) {
                System.err.println("Target in 'NUMERIC' and model is 'Classifier'.");
                return false;
            }
            if (var1_1.isTargetNominal() && !var2_2.isClassifier()) {
                System.err.println("Target in 'NOMINAL' and model is 'Predictor'.");
                return false;
            }
        }
        return true;
    }
}

