/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.adtree;

import java.io.Serializable;
import java.util.Enumeration;
import weka.classifiers.trees.ADTree;
import weka.classifiers.trees.adtree.Splitter;
import weka.core.FastVector;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public final class PredictionNode
implements Serializable,
Cloneable,
RevisionHandler {
    private static final long serialVersionUID = 6018958856358698814L;
    private double value;
    private FastVector children;

    public PredictionNode(double newValue) {
        this.value = newValue;
        this.children = new FastVector();
    }

    public final void setValue(double newValue) {
        this.value = newValue;
    }

    public final double getValue() {
        return this.value;
    }

    public final FastVector getChildren() {
        return this.children;
    }

    public final Enumeration children() {
        return this.children.elements();
    }

    public final void addChild(Splitter newChild, ADTree addingTo) {
        Splitter oldEqual = null;
        Enumeration e = this.children();
        while (e.hasMoreElements()) {
            Splitter split = (Splitter)e.nextElement();
            if (!newChild.equalTo(split)) continue;
            oldEqual = split;
            break;
        }
        if (oldEqual == null) {
            Splitter addChild = (Splitter)newChild.clone();
            this.setOrderAddedSubtree(addChild, addingTo);
            this.children.addElement(addChild);
        } else {
            int i = 0;
            while (i < newChild.getNumOfBranches()) {
                PredictionNode oldPred = oldEqual.getChildForBranch(i);
                PredictionNode newPred = newChild.getChildForBranch(i);
                if (oldPred != null && newPred != null) {
                    oldPred.merge(newPred, addingTo);
                }
                ++i;
            }
        }
    }

    public final Object clone() {
        PredictionNode clone = new PredictionNode(this.value);
        Enumeration e = this.children.elements();
        while (e.hasMoreElements()) {
            clone.children.addElement((Splitter)((Splitter)e.nextElement()).clone());
        }
        return clone;
    }

    public final void merge(PredictionNode merger, ADTree mergingTo) {
        this.value += merger.value;
        Enumeration e = merger.children();
        while (e.hasMoreElements()) {
            this.addChild((Splitter)e.nextElement(), mergingTo);
        }
    }

    private final void setOrderAddedSubtree(Splitter addChild, ADTree addingTo) {
        addChild.orderAdded = addingTo.nextSplitAddedOrder();
        int i = 0;
        while (i < addChild.getNumOfBranches()) {
            PredictionNode node = addChild.getChildForBranch(i);
            if (node != null) {
                Enumeration e = node.children();
                while (e.hasMoreElements()) {
                    this.setOrderAddedSubtree((Splitter)e.nextElement(), addingTo);
                }
            }
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

