% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.R
\name{make}
\alias{make}
\title{Run \code{make} in the system}
\usage{
make(..., .stdout = "", .stderr = "", .stdin = "")
}
\arguments{
\item{...}{Command-line arguments passed to the \code{make} command
(see \code{?make} in your shell for details)}

\item{.stdout}{Where to direct standard output; see \code{\link[base:system2]{base::system2()}}.}

\item{.stderr}{Where to direct standard error; see \code{\link[base:system2]{base::system2()}}.}

\item{.stdin}{Where to get standard input; see \code{\link[base:system2]{base::system2()}}}
}
\value{
Exit status of the command; see \code{\link[base:system2]{base::system2()}} for details.
}
\description{
This function executes the \code{make} command to rebuild all dependencies according to the \code{Makefile}
generated by \code{\link[=makefile]{makefile()}}.
}
\examples{
\dontrun{
  make()        # make all
  make('clean') # make the 'clean' task
  make('-j', 4) # make with 4 processes in parallel
}
}
\seealso{
\code{\link[=makefile]{makefile()}}, \code{\link[=rmakeSkeleton]{rmakeSkeleton()}}
}
\author{
Michal Burda
}
