% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_defillama_protocol_hist_tvl.R
\name{get_defillama_protocol_hist_tvl}
\alias{get_defillama_protocol_hist_tvl}
\title{Protocol History Data}
\usage{
get_defillama_protocol_hist_tvl(slug, by_token = FALSE)
}
\arguments{
\item{slug}{A string representing the unique name (slug) of the protocol.
This slug can be obtained from the result of the \code{\link{get_defillama_protocol_tvl}} function.}

\item{by_token}{A boolean indicating whether to include token-specific data. Defaults to FALSE.}
}
\value{
A `data.table` object containing historical TVL data of the specified protocol.
The table includes columns for date, TVL in USD. It is sorted by date.
}
\description{
Fetches historical TVL data for a specified DeFi protocol,
including TVL in USD and token amount. The data is returned as a table sorted by date.
}
\examples{
# total tvl by date
protocol_tvl = get_defillama_protocol_hist_tvl( "lido" )
tail( protocol_tvl )

# tvl by token
protocol_tvl = get_defillama_protocol_hist_tvl( "lido", by_token = TRUE )
tail( protocol_tvl )
}
