% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KrigingClass.R
\name{logLikelihood.Kriging}
\alias{logLikelihood.Kriging}
\alias{logLikelihood,Kriging,Kriging-method}
\title{Get Log-Likelihood of Kriging Model}
\usage{
\method{logLikelihood}{Kriging}(object, ...)
}
\arguments{
\item{object}{An S3 Kriging object.}

\item{...}{Not used.}
}
\value{
The log-Likelihood computed for fitted
    \eqn{\boldsymbol{theta}}{\theta}.
}
\description{
Get Log-Likelihood of Kriging Model
}
\examples{
f <- function(x) 1 - 1 / 2 * (sin(12 * x) / (1 + x) + 2 * cos(7 * x) * x^5 + 0.7)
set.seed(123)
X <- as.matrix(runif(10))
y <- f(X)

k <- Kriging(y, X, kernel = "matern3_2", objective="LL")
print(k)

logLikelihood(k)
}
\author{
Yann Richet \email{yann.richet@irsn.fr}
}
