% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TSP-Algorithms}
\alias{TSP-Algorithms}
\alias{ChristofidesRunner}
\alias{GreedyTSPRunner}
\alias{InsertionTSPRunner}
\alias{NearestNeighborTSPRunner}
\alias{Opt2TSPRunner}
\title{Traveling Salesperson Algorithms on Full Graphs}
\usage{
ChristofidesRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

GreedyTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

InsertionTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

NearestNeighborTSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)

Opt2TSPRunner(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  defaultEdgeWeight = 999999L
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{defaultEdgeWeight}{The default edge weight if an edge is not-specified (default value 999999)}
}
\value{
A list with 1) the list of tour vertices, and 2) the total tour cost
}
\description{
`ChristofidesRunner` runs the Christofides Heuristic

`GreedyTSPRunner` runs the Greedy Heuristic

`InsertionTSPRunner` runs the Insertion Heuristic

`NearestNeighborTSPRunner` runs the Nearest-Neighbor Heuristic

`Opt2TSPRunner` runs a 2-OPT heuristic
}
