% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shortestpath.R
\name{ShortestPath}
\alias{ShortestPath}
\title{ShortestPath}
\usage{
ShortestPath(
  arcSources,
  arcTargets,
  arcDistances,
  numNodes,
  sourceNode,
  destNode,
  algorithm = "Suurballe"
)
}
\arguments{
\item{arcSources}{Vector corresponding to the source nodes of a graph's
edges}

\item{arcTargets}{Vector corresponding to the destination nodes of a graph's
edges}

\item{arcDistances}{Vector corresponding to the distances of a graph's edges}

\item{numNodes}{The number of nodes in the graph}

\item{sourceNode}{The start node of the path}

\item{destNode}{The end node of the path}

\item{algorithm}{Which algorithm to run. Choices include "Suurballe" where
"Suurballe" is the default. See
<https://lemon.cs.elte.hu/pub/doc/1.3.1/a00420.html> for more information.}
}
\value{
A list containing two entries: 1) the number of paths from the start
  node to the end node and 2) a list of paths found.
}
\description{
Finds the shortest arc disjoint paths between two nodes in a directed graph.
This implementation runs a variation of the successive shortest path algorithm.
}
