% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{setProperties}
\alias{setProperties}
\title{Set properties of the chart}
\usage{
setProperties(data, chartId, layerId = NULL)
}
\arguments{
\item{data}{List of properties to be redefined for this layer or chart. Created by the \code{\link{dat}}
function.}

\item{chartId}{ID of the chart, for which to redefine properties.}

\item{layerId}{ID of the layer, for which to redefine properties. If the chart has a single
layer or doesn't have layers, default value (which is NULL) can be used.}
}
\description{
Sets or resets properties for an
existing chart. Changes will be applied to all currently opened and future pages.
This function is a wrapper around method \code{setProperties} of class \code{\link{LCApp}}.
}
\examples{
\donttest{data("iris")
lc_scatter(dat(x = iris$Sepal.Length, y = iris$Sepal.Width), chartId = "irisScatter")
setProperties(dat(symbolValue = iris$Species, y = iris$Petal.Length), chartId = "irisScatter")
updateCharts("irisScatter")

lc_line(dat(x = iris$Sepal.Length, y = iris$Petal.Length), chartId = "irisScatter", 
        layerId = "line")
setProperties(dat(colour = "red"), chartId = "irisScatter", layerId = "line")
updateCharts("irisScatter")}

}
