% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots.R
\name{list2}
\alias{list2}
\alias{ll}
\alias{dots_list}
\title{Collect dots in a list}
\usage{
list2(...)

dots_list(
  ...,
  .named = FALSE,
  .ignore_empty = c("trailing", "none", "all"),
  .preserve_empty = FALSE,
  .homonyms = c("keep", "first", "last", "error"),
  .check_assign = FALSE
)
}
\arguments{
\item{...}{Arguments to collect in a list. These dots are
\link[=dyn-dots]{dynamic}.}

\item{.named}{Whether to ensure all dots are named. Unnamed
elements are processed with \code{\link[=as_label]{as_label()}} to build a default
name.}

\item{.ignore_empty}{Whether to ignore empty arguments. Can be one
of \code{"trailing"}, \code{"none"}, \code{"all"}. If \code{"trailing"}, only the
last argument is ignored if it is empty.}

\item{.preserve_empty}{Whether to preserve the empty arguments that
were not ignored. If \code{TRUE}, empty arguments are stored with
\code{\link[=missing_arg]{missing_arg()}} values. If \code{FALSE} (the default) an error is
thrown when an empty argument is detected.}

\item{.homonyms}{How to treat arguments with the same name. The
default, \code{"keep"}, preserves these arguments. Set \code{.homonyms} to
\code{"first"} to only keep the first occurrences, to \code{"last"} to keep
the last occurrences, and to \code{"error"} to raise an informative
error and indicate what arguments have duplicated names.}

\item{.check_assign}{Whether to check for \verb{<-} calls passed in
dots. When \code{TRUE} and a \verb{<-} call is detected, a warning is
issued to advise users to use \code{=} if they meant to match a
function parameter, or wrap the \verb{<-} call in braces otherwise.
This ensures assignments are explicit.}
}
\value{
A list containing the \code{...} inputs.
}
\description{
\code{list2(...)} is equivalent to \code{list(...)} with a few additional
features, collectively called \link[=dyn-dots]{dynamic dots}. While
\code{list2()} hard-code these features, \code{dots_list()} is a lower-level
version that offers more control.
}
\examples{
# Let's create a function that takes a variable number of arguments:
numeric <- function(...) {
  dots <- list2(...)
  num <- as.numeric(dots)
  set_names(num, names(dots))
}
numeric(1, 2, 3)

# The main difference with list(...) is that list2(...) enables
# the `!!!` syntax to splice lists:
x <- list(2, 3)
numeric(1, !!! x, 4)

# As well as unquoting of names:
nm <- "yup!"
numeric(!!nm := 1)


# One useful application of splicing is to work around exact and
# partial matching of arguments. Let's create a function taking
# named arguments and dots:
fn <- function(data, ...) {
  list2(...)
}

# You normally cannot pass an argument named `data` through the dots
# as it will match `fn`'s `data` argument. The splicing syntax
# provides a workaround:
fn("wrong!", data = letters)  # exact matching of `data`
fn("wrong!", dat = letters)   # partial matching of `data`
fn(some_data, !!!list(data = letters))  # no matching


# Empty arguments trigger an error by default:
try(fn(, ))

# You can choose to preserve empty arguments instead:
list3 <- function(...) dots_list(..., .preserve_empty = TRUE)

# Note how the last empty argument is still ignored because
# `.ignore_empty` defaults to "trailing":
list3(, )

# The list with preserved empty arguments is equivalent to:
list(missing_arg())


# Arguments with duplicated names are kept by default:
list2(a = 1, a = 2, b = 3, b = 4, 5, 6)

# Use the `.homonyms` argument to keep only the first of these:
dots_list(a = 1, a = 2, b = 3, b = 4, 5, 6, .homonyms = "first")

# Or the last:
dots_list(a = 1, a = 2, b = 3, b = 4, 5, 6, .homonyms = "last")

# Or raise an informative error:
try(dots_list(a = 1, a = 2, b = 3, b = 4, 5, 6, .homonyms = "error"))


# dots_list() can be configured to warn when a `<-` call is
# detected:
my_list <- function(...) dots_list(..., .check_assign = TRUE)
my_list(a <- 1)

# There is no warning if the assignment is wrapped in braces.
# This requires users to be explicit about their intent:
my_list({ a <- 1 })
}
