% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{quosure}
\alias{quosure}
\alias{is_quosure}
\alias{quo_is_missing}
\alias{quo_is_symbol}
\alias{quo_is_call}
\alias{quo_is_symbolic}
\alias{quo_is_null}
\alias{quo_get_expr}
\alias{quo_get_env}
\alias{quo_set_expr}
\alias{quo_set_env}
\title{Quosure getters, setters and testers}
\usage{
is_quosure(x)

quo_is_missing(quo)

quo_is_symbol(quo, name = NULL)

quo_is_call(quo, name = NULL, n = NULL, ns = NULL)

quo_is_symbolic(quo)

quo_is_null(quo)

quo_get_expr(quo)

quo_get_env(quo)

quo_set_expr(quo, expr)

quo_set_env(quo, env)
}
\arguments{
\item{x}{An object to test.}

\item{quo}{A quosure to test.}

\item{name}{The name of the symbol or function call. If \code{NULL} the
name is not tested.}

\item{n}{An optional number of arguments that the call should
match.}

\item{ns}{The namespace of the call. If \code{NULL}, the namespace
doesn't participate in the pattern-matching. If an empty string
\code{""} and \code{x} is a namespaced call, \code{is_call()} returns
\code{FALSE}. If any other string, \code{is_call()} checks that \code{x} is
namespaced within \code{ns}.

Can be a character vector of namespaces, in which case the call
has to match at least one of them, otherwise \code{is_call()} returns
\code{FALSE}.}

\item{expr}{A new expression for the quosure.}

\item{env}{A new environment for the quosure.}
}
\description{
A quosure is a type of \link[=quotation]{quoted expression} that includes
a reference to the context where it was created. A quosure is thus
guaranteed to evaluate in its original environment and can refer to
local objects.

You can access the quosure components (its expression and its
environment) with:
\itemize{
\item \code{\link[=get_expr]{get_expr()}} and \code{\link[=get_env]{get_env()}}. These getters also support other
kinds of objects such as formulas.
\item \code{quo_get_expr()} and \code{quo_get_env()}. These getters only work
with quosures and throw an error with other types of input.
}

Test if an object is a quosure with \code{is_quosure()}. If you know an
object is a quosure, use the \code{quo_} prefixed predicates to check
its contents, \code{quo_is_missing()}, \code{quo_is_symbol()}, etc.
}
\section{Quosured constants}{


A quosure usually does not carry environments for \link[=is_syntactic_literal]{constant objects} like strings or numbers. \code{\link[=quo]{quo()}} and
\code{\link[=enquo]{enquo()}} only capture an environment for \link[=is_symbolic]{symbolic expressions}. For instance, all of these return the
\link[=empty_env]{empty environment}:\preformatted{quo_get_env(quo("constant"))
quo_get_env(quo(100))
quo_get_env(quo(NA))
}

On the other hand, quosures capture the environment of symbolic
expressions, i.e. expressions whose meaning depends on the
environment in which they are evaluated and what objects are
defined there:\preformatted{quo_get_env(quo(some_object))
quo_get_env(quo(some_function()))
}
}

\section{Empty quosures}{


When missing arguments are captured as quosures, either through
\code{\link[=enquo]{enquo()}} or \code{\link[=quos]{quos()}}, they are returned as an empty quosure. These
quosures contain the \link[=missing_arg]{missing argument} and typically
have the \link[=empty_env]{empty environment} as enclosure.
}

\section{Life cycle}{

\itemize{
\item \code{is_quosure()} is stable.
\item \code{quo_get_expr()} and \code{quo_get_env()} are stable.
\item \code{is_quosureish()} is deprecated as of rlang 0.2.0. This function
assumed that quosures are formulas which is currently true but
might not be in the future.
}
}

\examples{
quo <- quo(my_quosure)
quo


# Access and set the components of a quosure:
quo_get_expr(quo)
quo_get_env(quo)

quo <- quo_set_expr(quo, quote(baz))
quo <- quo_set_env(quo, empty_env())
quo

# Test wether an object is a quosure:
is_quosure(quo)

# If it is a quosure, you can use the specialised type predicates
# to check what is inside it:
quo_is_symbol(quo)
quo_is_call(quo)
quo_is_null(quo)

# quo_is_missing() checks for a special kind of quosure, the one
# that contains the missing argument:
quo()
quo_is_missing(quo())

fn <- function(arg) enquo(arg)
fn()
quo_is_missing(fn())
}
\seealso{
\code{\link[=quo]{quo()}} for creating quosures by quotation; \code{\link[=as_quosure]{as_quosure()}}
and \code{\link[=new_quosure]{new_quosure()}} for constructing quosures manually.
}
