% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnd.R
\name{catch_cnd}
\alias{catch_cnd}
\title{Catch a condition}
\usage{
catch_cnd(expr)
}
\arguments{
\item{expr}{Expression to be evaluated with a catch-all condition
handler.}
}
\value{
A condition if any was signalled, \code{NULL} otherwise.
}
\description{
This is a small wrapper around \code{tryCatch()} that captures any
condition signalled while evaluating its argument. It is useful for
debugging and unit testing.
}
\examples{
catch_cnd(10)
catch_cnd(abort("an error"))
catch_cnd(cnd_signal("my_condition", .msg = "a condition"))
}
