% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultpost.R
\name{defaultpost}
\alias{defaultpost}
\title{Perform Post-Processing Using Default Bijections}
\usage{
defaultpost(posterior, likelihood, param.prior, model.prior,
  chainlength = 10000, TM.thin = chainlength/10, progress = TRUE,
  save.all = TRUE)
}
\arguments{
\item{posterior}{A list of N matrices containing the posterior distributions 
under each model. Generally this will be obtained from MCMC output. Note
that each parameter should be real-valued so some parameters may need to be
transformed, using logarithms for example.}

\item{likelihood}{A list of N functions specifying the log-likelihood 
functions for the data under each model.}

\item{param.prior}{A list of N functions specifying the prior distributions 
for each model-specific parameter vector.}

\item{model.prior}{A numeric vector of the prior model probabilities. Note 
that this argument is not required to sum to one as it is automatically 
normalised.}

\item{chainlength}{How many iterations to run the Markov chain for.}

\item{TM.thin}{How regularly to calculate transition matrices as the chain 
progresses.}

\item{progress}{A logical determining whether a progress bar is drawn.}

\item{save.all}{A logical determining whether to save the value of the 
universal parameter at each iteration, as well as the corresponding 
likelihoods, priors and posteriors. If \code{TRUE}, the output object 
occupies significantly more memory.}
}
\value{
Returns an object of class \code{rj} (see \code{\link{rjmethods}}). 
  If \code{save.all=TRUE}, the output has named elements \code{result}, 
  \code{densities}, \code{psidraws}, \code{progress} and \code{meta}. If 
  \code{save.all=FALSE}, the \code{densities} and \code{psidraws} elements 
  are omitted.
  
  \code{result} contains useful point estimates, \code{progress} contains
  snapshots of these estimates over time, and \code{meta} contains
  information about the function call.
}
\description{
Performs Bayesian multimodel inference, estimating Bayes factors and 
posterior model probabilities for N candidate models. Unlike 
\code{\link{rjmcmcpost}}, this function uses a default bijection scheme based
on approximating each posterior by a multivariate normal distribution. The 
result is reminiscent of the algorithm of Carlin & Chib (1995) with a 
multivariate normal pseudo-prior. Transformation Jacobians are computed using
automatic differentiation so do not need to be specified.
}
\examples{
## Comparing two binomial models -- see Barker & Link (2013) for further details.

y=c(8,16); sumy=sum(y)
n=c(20,30); sumn=sum(n)

L1=function(p){if((all(p>=0))&&(all(p<=1))) sum(dbinom(y,n,p,log=TRUE)) else -Inf}
L2=function(p){if((p[1]>=0)&&(p[1]<=1)) sum(dbinom(y,n,p[1],log=TRUE)) else -Inf}

p.prior1=function(p){sum(dbeta(p,1,1,log=TRUE))}
p.prior2=function(p){dbeta(p[1],1,1,log=TRUE)+dbeta(p[2],17,15,log=TRUE)}

coda1=matrix(rbeta(2000,y+1,n-y+1), 1000, 2, byrow=TRUE)  ## full conditional posterior
coda2=matrix(c(rbeta(1000,sumy+1,sumn-sumy+1),rbeta(1000,17,15)), 1000, 2)

out=defaultpost(posterior=list(coda1,coda2), likelihood=list(L1,L2), 
                param.prior=list(p.prior1,p.prior2), model.prior=c(1,1), chainlength=1000)

}
\references{
Carlin, B. P. and Chib, S. (1995) Bayesian Model Choice via 
  Markov Chain Monte Carlo Methods. \emph{Journal of the Royal Statistical 
  Society, Series B, 473-484}.

Barker, R. J. and Link, W. A. (2013) Bayesian multimodel 
  inference by RJMCMC: A Gibbs sampling approach. \emph{The American 
  Statistician, 67(3), 150-156}.
}
\seealso{
\code{\link{adiff}} \code{\link{rjmcmcpost}}
}
