\name{arrayInd}
\alias{arrayInd}
\title{
Faster calculation of array indices from vector position.
}
\description{
Calculates array indices based on linear position in an array.
}
\usage{
arrayInd(ind, .dim, .dimnames = NULL, useNames = FALSE)
}
\arguments{
  \item{ind}{
integer-valued vector of indices.
}
  \item{.dim}{
integer vector givine dimensions of array.
}
  \item{.dimnames}{
optional list of character \code{\link{dimnames}(.)}, of which only \code{.dimnames[[1]]} is used.
}
  \item{useNames}{
logical indicating if the value of \code{arrayInd()} should have (non-null) dimnames at all.
}
}
\details{
This is a \code{C} implementation of the \code{base} function of the same name.  Results should be the same.

Given a vector of integers giving the vector position of entries in an array, returns the appropriate array indices.
}
\value{
A matrix whose rows each are the indices of one element of \code{x}; see Examples below.
}
\author{
Robin Evans
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link[base]{arrayInd}}.
}
\examples{
arr = array(1:36, dim=c(2,3,2,3))
ind = arrayInd(c(4,9,17), c(2,3,2,3))
ind

arr[2,2,1,1]
arr[1,2,2,1]
arr[1,3,1,2]
}
\keyword{array}
