\name{RiverBar}
\alias{RiverBar}

\title{
  River Bar-Chart
}
\description{
  This plots bars for quantitative data on the river chart.
}
\usage{
RiverBar(site, river, distance, value, riverlayout,
         range = NA, bar.w = 1, bar.col = NA, bd.col = "black",
         lbl.cex = 0.7, lbl.adj = c(0.5,2), lbl.ofs = 0.5,
         lbl.col = "black", lbl.srt = 0, lbl.pos = NULL,
         lbl.shw = TRUE, pt.shw = FALSE)
}

\arguments{
  \item{site}{
    a character vector of site names.
  }
  \item{river}{
    a vector of rivers on which the sites are located.
  }
  \item{distance}{
    a vector. The along-the-river distances between the sites and the mouth of the river.
  }
  \item{value}{
    a data frame containing the variables to be shown on the bar-chart.
  }  
  \item{riverlayout}{
    the output list of \code{RiverLayout} or \code{RiverMap}.
  }
  \item{range}{
    bar-chart value range. A vector of two values indicating lower limit and upper limit.
  }

  \item{bar.w}{
    relative width of each bar plotted in the diagram. The default value is \code{1}.
  }  
  \item{bar.col}{
    bar colour.
  }
  \item{bd.col}{
    bar border colour.
  }
  \item{pt.shw}{
    show location point (\code{TRUE}) or not (\code{FALSE}).
  }  
  \item{lbl.cex}{
    label size.
  }
  \item{lbl.adj}{
    label adjustment. One or two values in [0,1] for x and y (optional) adjustment.
  }
  \item{lbl.ofs}{
    label position offset.
  }
  \item{lbl.col}{
    label colour.
  }
  \item{lbl.srt}{
    label angle.
  }
  \item{lbl.pos}{
    label position. \code{1} for below, \code{2} for left, \code{3} for above, and \code{4} for right. See \code{par} for details.
  }
  \item{lbl.shw}{
    show labels (\code{TRUE}) or not (\code{FALSE}).
  }
}

\author{
  Feng Mao
  }

\seealso{
  \code{\link{RiverLayout}},
  \code{\link{RiverDraw}},
  \code{\link{RiverMap}},
  \code{\link{par}}.
}


\examples{

data(Ballinderry)

riverlayout <- RiverLayout(B.river$River,B.river$Length,
                           B.river$Parent,B.river$Position,
                           B.river$Distance, direction = -1)
RiverDraw(riverlayout)

RiverBar(B.bio$Site, B.bio$River, B.bio$Distance, B.bio[4:5], riverlayout, 
         bar.col = c("#5381FFFF", "#7BE859FF"), lbl.shw = TRUE)

RiverDraw(riverlayout)

RiverBar(B.bio$Site, B.bio$River, B.bio$Distance, B.bio[4:5], riverlayout, 
         bar.col = c("#5381FFFF", "#7BE859FF"), range = c(4,7))
}

\keyword{hplot}

