% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/margstd-utils.R
\name{confint.margstd_boot}
\alias{confint.margstd_boot}
\title{Bootstrap confidence intervals}
\usage{
\method{confint}{margstd_boot}(
  object,
  parm = NULL,
  level = 0.95,
  bootrepeats = 1000,
  bootci = c("bca", "normal", "nonpar"),
  jacksd = FALSE,
  ...
)
}
\arguments{
\item{object}{Model fitted through marginal standardization}

\item{parm}{Not used, for compatibility}

\item{level}{Confidence level, defaults to 0.95.}

\item{bootrepeats}{Bootstrap repeats. Defaults to 1000. Consider increasing.}

\item{bootci}{Type of bootstrap confidence interval:
\itemize{
\item \code{"bca"} Default. Parametric BCa (bias-corrected accelerated)
confidence intervals.
\item \code{"normal"} Parametric normality-based confidence intervals,
which require lower repeat numbers but are less accurate and
may result in invalid results for ratios.
\item \code{"nonpar"} Non-parametric BCa confidence intervals,
which should be used with caution because of the risk
of sparse-data bias with non-parametric bootstrapping.
}}

\item{jacksd}{Return jackknife Monte-Carlo error for the confidence limits?
Only functional with BCa confidence intervals. Defaults to \code{FALSE}.}

\item{...}{Not used}
}
\value{
Matrix: First column, lower bound; second column, upper bound.
}
\description{
Confidence intervals for models fit using marginal standardization
based on parametric bootstrapping.
}
