% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoxInfo.R
\name{CoxVariableName}
\alias{CoxVariableName}
\title{Extract variable names from a model}
\usage{
CoxVariableName(object)
}
\arguments{
\item{object}{The fitted Cox regression model object either
obtained with \code{coxph} (survival package) or \code{cph}
(rms package).}
}
\description{
Extract the name of the variables belonging to the linear predictor or used to form the strata
}
\examples{
\dontrun{
d <- sampleData(1e2, outcome = "survival")
d$entry <- 0
d$id <- 1:NROW(d)

##
library(survival)
d$X1=factor(d$X1)
mCox <- coxph(Surv(time, event) ~ X1+X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCox)
mCoxS <- coxph(Surv(time, event) ~ strata(X1)+X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxS)
mCoxS2 <- coxph(Surv(time, event) ~ strata(X1)+strata(X2), data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxS2)
mCoxI <- coxph(Surv(time, event) ~ X1*X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxI)

##
library(rms)
mCox <- cph(Surv(time, event) ~ X1+X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCox) 
mCoxS <- cph(Surv(time, event) ~ strat(X1)+X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxS) 
mCoxS2 <- cph(Surv(time, event) ~ strat(X1)+strat(X2), data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxS2) 
mCoxI <- cph(Surv(time, event) ~ X1*X2, data = d, x = TRUE, y = TRUE)
CoxVariableName(mCoxI)

##
library(mets)
mCox <- phreg(Surv(entry, time, event) ~ X1+X2, data = d)
CoxVariableName(mCox) 
mCoxS <- phreg(Surv(entry, time, event) ~ strata(X1)+cluster(id)+X2, data = d)
CoxVariableName(mCoxS) 
mCoxI <- phreg(Surv(entry, time, event) ~ X1*X2, data = d)
CoxVariableName(mCoxI)
}
}
\author{
Brice Ozenne broz@sund.ku.dk
}
