% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{Dist}
\alias{Dist}
\title{Construct a distribution}
\usage{
Dist(n)
}
\arguments{
\item{n}{Vector or matrix specifying one or more time series.}
}
\value{
An initialized object of class Dist.
}
\description{
If the parameter \code{n} is an integer, the distribution is constructed
with a zeroed support of size \code{n}. If \code{n} is a vector of integer
values, the sequence is treated as the underlying support. On the other hand,
if \code{n} is a vector of floating point values, it is treated as a
probability distribution and must sum to unity. Note, if a probability
distribution is given as the underlying support, it will first be converted
to a histogram with a precision of 9 significant figures.
}
\examples{
Dist(5)
Dist(c(0, 0, 3, 5, 1))
Dist(c(0.0, 0.1, 0.25, 0.25, 0.4))
}
