% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{encode}
\alias{encode}
\title{Encode}
\usage{
encode(state, b = NA)
}
\arguments{
\item{state}{Vector of the state to encode.}

\item{b}{Numeric giving the base in which to encode.}
}
\value{
Numeric giving the encoded state.
}
\description{
Encode a base-\code{b} array of integers into a single integer. This function
uses a big-endian encoding scheme. That is, the most significant bits of the
encoded integer are determined by the left-most end of the unencoded state.
}
\examples{
# With specified base
encode(c(0, 0, 1), b = 2) # 1
encode(c(0, 1, 0), b = 3) # 3
encode(c(1, 0, 0), b = 4) # 16

# Without specified base
encode(c(0, 0, 2)) # 2
encode(c(0, 2, 0)) # 6
encode(c(1, 2, 1)) # 16
}
