% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{bin_series}
\alias{bin_series}
\title{State Binning}
\usage{
bin_series(series, b = NA, step = NA, bounds = NA)
}
\arguments{
\item{series}{Vector of the continuously-valued time series to bin.}

\item{b}{Numeric giving the desired number of uniform bins.}

\item{step}{Numeric giving the desired size of each uniform bin.}

\item{bounds}{Vector of the finite bounds of each bin.}
}
\value{
List giving the binned sequence, the number of bins and either the
        bin sizes or bin bounds.
}
\description{
Bin a continuously-valued times series. The binning can be performed in any
one of three ways. The first is binning the time series into \code{b}
uniform bins (with \code{b} an integer). The second type of binning produces
bins of a specific size \code{step}. The third type of binning breaks the
real number line into segments with specified boundaries or thresholds, and
the time series is binned according to this partitioning. The bounds are
expected to be provided in ascending order.
}
\examples{
# First method: bin into uniform bins
xs <- runif(20, 0, 5)
bin_series(xs, b = 5)

# Second method: bins of specific size <step>
bin_series(xs, step = 1)

# Third method: bins of specific size <step>
bounds <- c(2.0, 5.0)
bin_series(xs, bounds = bounds)

}
