% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{maxima.options}
\alias{maxima.options}
\title{maxima.options}
\usage{
maxima.options(
  ...,
  RESET = FALSE,
  READ.ONLY = NULL,
  LOCAL = FALSE,
  ADD = FALSE
)
}
\arguments{
\item{...}{options to be accessed by using \code{name = value}. Options can be added by setting \code{ADD = TRUE}, but only those mentioned below will be used my rim.}

\item{RESET}{logical of length 1, whether to reset all options to default values.}

\item{READ.ONLY}{logical of length 1, can be used to output all options that are read-only.}

\item{LOCAL}{logical of length 1, to output all options that are defined locally.}

\item{ADD}{logical of length 1, whether to add the specified option in \code{...} (TRUE), default is FALSE.}
}
\description{
Function for globally setting and retrieving options.
}
\details{
\describe{
  \item{\code{format}: }{character vector of length 1 setting the output format for \code{maxima.get()}. Can be one of \code{"linear",} \code{"ascii",} \code{"latex"} or \code{"mathml"}.}
  \item{\code{engine.format}: }{same as option \code{format}, but for outputs in \code{RMarkdown} documents.}
  \item{\code{inline.format}: }{character string setting the output format for \code{maxima.inline()}, for knitting outputs inline into \code{RMarkdown} documents. Can be one of \code{"linear"}, \code{"latex"} or \code{"mathml"}, but \emph{not} \code{"ascii"}.}
  \item{\code{label}: }{logical of length 1, whether reference labels should be printed for returned S3 objects from \code{\link{maxima.get}()} (TRUE, default), or not (FALSE). This also applies to printing of input commands using \code{\link{iprint}()}.}
  \item{\code{engine.label}: }{same as \code{label}, but for outputs in \code{RMarkdown} documents.}
  \item{\code{inline.label}: }{same as \code{label}, but for inline outputs in \code{RMarkdown} documents.}
}
}
