% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prices.R
\name{riingo_prices}
\alias{riingo_prices}
\title{Get stock or ETF prices from the Tiingo API}
\usage{
riingo_prices(
  ticker,
  start_date = NULL,
  end_date = NULL,
  resample_frequency = "daily"
)
}
\arguments{
\item{ticker}{One or more tickers to download data for from Tiingo. Can be a
stock, mutual fund, or ETF. A character vector.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}

\item{resample_frequency}{For Tiingo data, a character specified as one of:
\code{"daily"}, \code{"weekly"}, \code{"monthly"} or \code{"annually"}.

For IEX data, a character specified at the \code{"min"} or \code{"hour"} frequencies
in the form: \code{"1min"}, \code{"5min"}, or \code{"2hour"}.

For Crypto data, a character specified at the \code{"min"}, \code{"hour"} or \code{"day"}
frequencies similar to IEX.}
}
\description{
The Tiingo API provides a large feed of historical data at the
daily (and weekly, monthly, or annual) level.
}
\details{
Multiple downloads are done \emph{sequentially}, meaning that downloading 5 tickers
costs 5 requests against your usage limits. Sadly Tiingo does not support
batch downloads at the moment.

\strong{Tiingo supplied documentation regarding the resample frequency:}
\itemize{
\item daily: Values returned as daily periods, with a holiday calendar
\item weekly: Values returned as weekly data, with days ending on Friday
\item monthly: Values returned as monthly data, with days ending on the last standard business day (Mon-Fri) of each month
\item annually: Values returned as annual data, with days ending on the last standard business day (Mon-Fri) of each year
\item Note, that if you choose a value in-between the resample period for weekly,
monthly, and daily, the start date rolls back to consider the entire period.
For example, if you choose to resample weekly, but your "start_date" parameter
is set to Wednesday of that week, the start_date will be adjusted to Monday,
so the entire week is captured. Another example is if you send a start_date
mid-month, we roll back the start_date to the beginning of the month.
\item Similarly, if you provide an end_date, and it's midway through the period,
we roll-forward the date to capture the whole period. In the above example,
if the end date is set to a wednesday with a weekly resample, the end date is
rolled forward to the Friday of that week.
}
}
\examples{

\dontrun{

# Downloading 1 year's worth of prices for AAPL
riingo_prices("AAPL")

# Downloading a range of data, using 2 tickers
riingo_prices(c("AAPL", "MSFT"), "1999-01-01", "2005-01-01")

# Monthly data
riingo_prices(c("AAPL", "MSFT"), "1999-01-01", "2005-01-01", "monthly")

}

}
