% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fundamentals-metrics.R
\name{riingo_fundamentals_metrics}
\alias{riingo_fundamentals_metrics}
\title{Fundamentals - Metrics}
\usage{
riingo_fundamentals_metrics(ticker, start_date = NULL, end_date = NULL)
}
\arguments{
\item{ticker}{One or more tickers to download financial metrics for.}

\item{start_date}{The first date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable. The default is to
download 1 year's worth of data.}

\item{end_date}{The last date to download data for.
A character in the form YYYY-MM-DD, or a \code{Date} variable.}
}
\value{
A data frame containing the financial metrics for the requested tickers.
}
\description{
This function collects daily financial metrics for the specificed tickers.
These might include market capitalization, P/E ratios, and more.
}
\examples{
\dontrun{
riingo_fundamentals_metrics(c("AAPL", "MSFT"), start_date = "2020-01-01")
}
}
\seealso{
Other fundamentals: 
\code{\link{riingo_fundamentals_definitions}()},
\code{\link{riingo_fundamentals_meta}()},
\code{\link{riingo_fundamentals_statements}()}
}
\concept{fundamentals}
