% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realms.R
\name{D14CtopMC}
\alias{D14CtopMC}
\title{Transform D14C into pMC}
\usage{
D14CtopMC(D14C, er = NULL, t)
}
\arguments{
\item{D14C}{The Delta14C value to translate}

\item{er}{Reported error of the D14C. Returns just the mean if left empty.}

\item{t}{the cal BP age}
}
\value{
The corresponding F14C value
}
\description{
Transform D14C into pMC
}
\details{
As explained by Heaton et al. 2020 (Radiocarbon), 14C measurements are commonly expressed in
three domains: Delta14C, F14C and the radiocarbon age. This function translates Delta14C, the historical level of Delta14C in the year t cal BP, to F14C values. Note that per convention, this function uses the Cambridge half-life, not the Libby half-life.
}
\examples{
  D14CtoF14C(-10, 1, 238)
}
