% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reallocate_units_4.R
\name{reallocate_units_4}
\alias{reallocate_units_4}
\title{reallocate_units_4}
\usage{
reallocate_units_4(snp.object, partition, threshold = 1e-05,
  min.clust.size = 20, split = FALSE, n.cores = 1)
}
\arguments{
\item{snp.object}{A snp.object containing the processed SNP data.}

\item{partition}{An integer vector indicating an initial partition of the isolates.}

\item{threshold}{The increase in marginal log likelihood required to accept a move.}

\item{min.clust.size}{Clusters smaller than min.clust.size will not be split.}

\item{split}{Whether to split only into two clusters (for move type 3).}

\item{n.cores}{The number of cores to use.}
}
\value{
The best partition after splitting a cluster and re-allocating as well as
a boolean value indicating whether a move increased the marginal likelihood.
}
\description{
Peform an iteration of the fourth move in the algorithm. That is split cluster into n
subclusters and re-allocate one sub-cluster.
}
