% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{rhandsontable}
\alias{rhandsontable}
\title{Handsontable widget}
\usage{
rhandsontable(data, colHeaders, rowHeaders, useTypes = TRUE,
  readOnly = NULL, selectCallback = FALSE, width = NULL, height = NULL,
  ...)
}
\arguments{
\item{data}{a \code{data.table}, \code{data.frame} or \code{matrix}}

\item{colHeaders}{a vector of column names. If missing \code{colnames}
will be used. Setting to \code{NULL} will omit.}

\item{rowHeaders}{a vector of row names. If missing \code{rownames}
will be used. Setting to \code{NULL} will omit.}

\item{useTypes}{logical specifying whether column classes should be mapped to
equivalent Javascript types}

\item{readOnly}{logical specifying whether the table is editable}

\item{selectCallback}{logical enabling the afterSelect event to return data.
This can be used with shiny to tie updates to a selected table cell.}

\item{width}{numeric table width}

\item{height}{numeric table height}

\item{...}{passed to hot_table}
}
\description{
Create a \href{http://handsontable.com}{Handsontable.js} widget.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF, rowHeaders = NULL)
}

