% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rhandsontable.R
\name{hot_table}
\alias{hot_table}
\title{Handsontable widget}
\usage{
hot_table(hot, contextMenu = TRUE, allowRowEdit = TRUE,
  allowColEdit = TRUE, customBorders = NULL, groups = NULL,
  highlightRow = NULL, highlightCol = NULL, comments = NULL,
  exportToCsv = NULL, csvFileName = "download.csv", ...)
}
\arguments{
\item{hot}{rhandsontable object}

\item{contextMenu}{logical enabling the right-click menu}

\item{allowRowEdit}{logical enabling right-click row options}

\item{allowColEdit}{logical enabling right-click column options}

\item{customBorders}{json object. See
\href{http://handsontable.com/demo/custom_borders.html}{Custom borders} for details.}

\item{groups}{json object. See
\href{http://handsontable.com/demo/grouping.html}{Grouping & ungrouping of rows and columns} for details.}

\item{highlightRow}{logical enabling row highlighting for the selected
cell}

\item{highlightCol}{logical enabling column highlighting for the
selected cell}

\item{comments}{logical enabling comments in the table, including the
corresponding options in the right-click menu. User comments are not
currently returned to R.}

\item{exportToCsv}{logical adding a context menu option to export the table
data to a csv file}

\item{csvFileName}{character csv file name}

\item{...}{passed to \href{http://handsontable.com}{Handsontable.js} constructor}
}
\description{
Configure table.  See
\href{http://handsontable.com}{Handsontable.js} for details.
}
\examples{
library(rhandsontable)
DF = data.frame(val = 1:10, bool = TRUE, big = LETTERS[1:10],
                small = letters[1:10],
                dt = seq(from = Sys.Date(), by = "days", length.out = 10),
                stringsAsFactors = FALSE)

rhandsontable(DF) \%>\%
hot_table(highlightCol = TRUE, highlightRow = TRUE,
          allowRowEdit = FALSE, allowColEdit = FALSE)
}

